/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.SdkRequest;
import software.amazon.awssdk.SdkResponse;
import software.amazon.awssdk.interceptor.Context;
import software.amazon.awssdk.interceptor.ExecutionAttributes;
import software.amazon.awssdk.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.BinaryUtils;

public class MessageMD5ChecksumInterceptor
implements ExecutionInterceptor {
    private static final int INTEGER_SIZE_IN_BYTES = 4;
    private static final byte STRING_TYPE_FIELD_INDEX = 1;
    private static final byte BINARY_TYPE_FIELD_INDEX = 2;
    private static final byte STRING_LIST_TYPE_FIELD_INDEX = 3;
    private static final byte BINARY_LIST_TYPE_FIELD_INDEX = 4;
    private static final String MD5_MISMATCH_ERROR_MESSAGE = "MD5 returned by SQS does not match the calculation on the original request. (MD5 calculated by the %s: \"%s\", MD5 checksum returned: \"%s\")";
    private static final String MD5_MISMATCH_ERROR_MESSAGE_WITH_ID = "MD5 returned by SQS does not match the calculation on the original request. (Message ID: %s, MD5 calculated by the %s: \"%s\", MD5 checksum returned: \"%s\")";
    private static final String MESSAGE_BODY = "message body";
    private static final String MESSAGE_ATTRIBUTES = "message attributes";
    private static final Logger log = LoggerFactory.getLogger(MessageMD5ChecksumInterceptor.class);

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        SdkResponse response = context.response();
        SdkRequest originalRequest = context.request();
        if (response != null) {
            if (originalRequest instanceof SendMessageRequest) {
                SendMessageRequest sendMessageRequest = (SendMessageRequest)originalRequest;
                SendMessageResponse sendMessageResult = (SendMessageResponse)response;
                MessageMD5ChecksumInterceptor.sendMessageOperationMd5Check(sendMessageRequest, sendMessageResult);
            } else if (originalRequest instanceof ReceiveMessageRequest) {
                ReceiveMessageResponse receiveMessageResult = (ReceiveMessageResponse)response;
                MessageMD5ChecksumInterceptor.receiveMessageResultMd5Check(receiveMessageResult);
            } else if (originalRequest instanceof SendMessageBatchRequest) {
                SendMessageBatchRequest sendMessageBatchRequest = (SendMessageBatchRequest)originalRequest;
                SendMessageBatchResponse sendMessageBatchResult = (SendMessageBatchResponse)response;
                MessageMD5ChecksumInterceptor.sendMessageBatchOperationMd5Check(sendMessageBatchRequest, sendMessageBatchResult);
            }
        }
    }

    private static void sendMessageOperationMd5Check(SendMessageRequest sendMessageRequest, SendMessageResponse sendMessageResult) {
        String attrMd5Returned;
        String clientSideAttrMd5;
        String messageBodySent = sendMessageRequest.messageBody();
        String bodyMd5Returned = sendMessageResult.md5OfMessageBody();
        String clientSideBodyMd5 = MessageMD5ChecksumInterceptor.calculateMessageBodyMd5(messageBodySent);
        if (!clientSideBodyMd5.equals(bodyMd5Returned)) {
            throw new AmazonClientException(String.format(MD5_MISMATCH_ERROR_MESSAGE, MESSAGE_BODY, clientSideBodyMd5, bodyMd5Returned));
        }
        Map<String, MessageAttributeValue> messageAttrSent = sendMessageRequest.messageAttributes();
        if (messageAttrSent != null && !messageAttrSent.isEmpty() && !(clientSideAttrMd5 = MessageMD5ChecksumInterceptor.calculateMessageAttributesMd5(messageAttrSent)).equals(attrMd5Returned = sendMessageResult.md5OfMessageAttributes())) {
            throw new AmazonClientException(String.format(MD5_MISMATCH_ERROR_MESSAGE, MESSAGE_ATTRIBUTES, clientSideAttrMd5, attrMd5Returned));
        }
    }

    private static void receiveMessageResultMd5Check(ReceiveMessageResponse receiveMessageResult) {
        if (receiveMessageResult.messages() != null) {
            for (Message messageReceived : receiveMessageResult.messages()) {
                String messageBody = messageReceived.body();
                String bodyMd5Returned = messageReceived.md5OfBody();
                String clientSideBodyMd5 = MessageMD5ChecksumInterceptor.calculateMessageBodyMd5(messageBody);
                if (!clientSideBodyMd5.equals(bodyMd5Returned)) {
                    throw new AmazonClientException(String.format(MD5_MISMATCH_ERROR_MESSAGE, MESSAGE_BODY, clientSideBodyMd5, bodyMd5Returned));
                }
                Map<String, MessageAttributeValue> messageAttr = messageReceived.messageAttributes();
                if (messageAttr == null || messageAttr.isEmpty()) continue;
                String attrMd5Returned = messageReceived.md5OfMessageAttributes();
                String clientSideAttrMd5 = MessageMD5ChecksumInterceptor.calculateMessageAttributesMd5(messageAttr);
                if (clientSideAttrMd5.equals(attrMd5Returned)) continue;
                throw new AmazonClientException(String.format(MD5_MISMATCH_ERROR_MESSAGE, MESSAGE_ATTRIBUTES, clientSideAttrMd5, attrMd5Returned));
            }
        }
    }

    private static void sendMessageBatchOperationMd5Check(SendMessageBatchRequest sendMessageBatchRequest, SendMessageBatchResponse sendMessageBatchResult) {
        HashMap<String, SendMessageBatchRequestEntry> idToRequestEntryMap = new HashMap<String, SendMessageBatchRequestEntry>();
        if (sendMessageBatchRequest.entries() != null) {
            for (SendMessageBatchRequestEntry sendMessageBatchRequestEntry : sendMessageBatchRequest.entries()) {
                idToRequestEntryMap.put(sendMessageBatchRequestEntry.id(), sendMessageBatchRequestEntry);
            }
        }
        if (sendMessageBatchResult.successful() != null) {
            for (SendMessageBatchResultEntry sendMessageBatchResultEntry : sendMessageBatchResult.successful()) {
                String messageBody = ((SendMessageBatchRequestEntry)idToRequestEntryMap.get(sendMessageBatchResultEntry.id())).messageBody();
                String bodyMd5Returned = sendMessageBatchResultEntry.md5OfMessageBody();
                String clientSideBodyMd5 = MessageMD5ChecksumInterceptor.calculateMessageBodyMd5(messageBody);
                if (!clientSideBodyMd5.equals(bodyMd5Returned)) {
                    throw new AmazonClientException(String.format(MD5_MISMATCH_ERROR_MESSAGE_WITH_ID, MESSAGE_BODY, sendMessageBatchResultEntry.id(), clientSideBodyMd5, bodyMd5Returned));
                }
                Map<String, MessageAttributeValue> messageAttr = ((SendMessageBatchRequestEntry)idToRequestEntryMap.get(sendMessageBatchResultEntry.id())).messageAttributes();
                if (messageAttr == null || messageAttr.isEmpty()) continue;
                String attrMd5Returned = sendMessageBatchResultEntry.md5OfMessageAttributes();
                String clientSideAttrMd5 = MessageMD5ChecksumInterceptor.calculateMessageAttributesMd5(messageAttr);
                if (clientSideAttrMd5.equals(attrMd5Returned)) continue;
                throw new AmazonClientException(String.format(MD5_MISMATCH_ERROR_MESSAGE_WITH_ID, MESSAGE_ATTRIBUTES, sendMessageBatchResultEntry.id(), clientSideAttrMd5, attrMd5Returned));
            }
        }
    }

    private static String calculateMessageBodyMd5(String messageBody) {
        byte[] expectedMd5;
        if (log.isDebugEnabled()) {
            log.debug("Message body: " + messageBody);
        }
        try {
            expectedMd5 = Md5Utils.computeMD5Hash((byte[])messageBody.getBytes(StringUtils.UTF8));
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate the MD5 hash of the message body. " + e.getMessage(), (Throwable)e);
        }
        String expectedMd5Hex = BinaryUtils.toHex((byte[])expectedMd5);
        if (log.isDebugEnabled()) {
            log.debug("Expected  MD5 of message body: " + expectedMd5Hex);
        }
        return expectedMd5Hex;
    }

    private static String calculateMessageAttributesMd5(Map<String, MessageAttributeValue> messageAttributes) {
        MessageDigest md5Digest;
        if (log.isDebugEnabled()) {
            log.debug("Message attribtues: " + messageAttributes);
        }
        ArrayList<String> sortedAttributeNames = new ArrayList<String>(messageAttributes.keySet());
        Collections.sort(sortedAttributeNames);
        try {
            md5Digest = MessageDigest.getInstance("MD5");
            for (String attrName : sortedAttributeNames) {
                MessageAttributeValue attrValue = messageAttributes.get(attrName);
                MessageMD5ChecksumInterceptor.updateLengthAndBytes(md5Digest, attrName);
                MessageMD5ChecksumInterceptor.updateLengthAndBytes(md5Digest, attrValue.dataType());
                if (attrValue.stringValue() != null) {
                    md5Digest.update((byte)1);
                    MessageMD5ChecksumInterceptor.updateLengthAndBytes(md5Digest, attrValue.stringValue());
                    continue;
                }
                if (attrValue.binaryValue() != null) {
                    md5Digest.update((byte)2);
                    MessageMD5ChecksumInterceptor.updateLengthAndBytes(md5Digest, attrValue.binaryValue());
                    continue;
                }
                if (attrValue.stringListValues().size() > 0) {
                    md5Digest.update((byte)3);
                    for (String strListMember : attrValue.stringListValues()) {
                        MessageMD5ChecksumInterceptor.updateLengthAndBytes(md5Digest, strListMember);
                    }
                    continue;
                }
                if (attrValue.binaryListValues().size() <= 0) continue;
                md5Digest.update((byte)4);
                for (ByteBuffer byteListMember : attrValue.binaryListValues()) {
                    MessageMD5ChecksumInterceptor.updateLengthAndBytes(md5Digest, byteListMember);
                }
            }
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate the MD5 hash of the message attributes. " + e.getMessage(), (Throwable)e);
        }
        String expectedMd5Hex = BinaryUtils.toHex((byte[])md5Digest.digest());
        if (log.isDebugEnabled()) {
            log.debug("Expected  MD5 of message attributes: " + expectedMd5Hex);
        }
        return expectedMd5Hex;
    }

    private static void updateLengthAndBytes(MessageDigest digest, String str) throws UnsupportedEncodingException {
        byte[] utf8Encoded = str.getBytes(StringUtils.UTF8);
        ByteBuffer lengthBytes = ByteBuffer.allocate(4).putInt(utf8Encoded.length);
        digest.update(lengthBytes.array());
        digest.update(utf8Encoded);
    }

    private static void updateLengthAndBytes(MessageDigest digest, ByteBuffer binaryValue) {
        ByteBuffer readOnlyBuffer = binaryValue.asReadOnlyBuffer();
        int size = readOnlyBuffer.remaining();
        ByteBuffer lengthBytes = ByteBuffer.allocate(4).putInt(size);
        digest.update(lengthBytes.array());
        digest.update(readOnlyBuffer);
    }
}

