/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.util.StringUtils;

public class ChangeMessageVisibilityRequestMarshaller
implements Marshaller<Request<ChangeMessageVisibilityRequest>, ChangeMessageVisibilityRequest> {
    public Request<ChangeMessageVisibilityRequest> marshall(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        if (changeMessageVisibilityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeMessageVisibilityRequest, "SQSClient");
        request.addParameter("Action", "ChangeMessageVisibility");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (changeMessageVisibilityRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)changeMessageVisibilityRequest.queueUrl()));
        }
        if (changeMessageVisibilityRequest.receiptHandle() != null) {
            request.addParameter("ReceiptHandle", StringUtils.fromString((String)changeMessageVisibilityRequest.receiptHandle()));
        }
        if (changeMessageVisibilityRequest.visibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringUtils.fromInteger((Integer)changeMessageVisibilityRequest.visibilityTimeout()));
        }
        return request;
    }
}

