/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encloses a receipt handle and an entry id for each message in <code> <a>ChangeMessageVisibilityBatch</a>.</code>
 * </p>
 * <important>
 * <p>
 * All of the following list parameters must be prefixed with <code>ChangeMessageVisibilityBatchRequestEntry.n</code>,
 * where <code>n</code> is an integer value starting with <code>1</code>. For example, a parameter list for this action
 * might look like this:
 * </p>
 * </important>
 * <p>
 * <code>&amp;amp;ChangeMessageVisibilityBatchRequestEntry.1.Id=change_visibility_msg_2</code>
 * </p>
 * <p>
 * <code>&amp;amp;ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle=&lt;replaceable&gt;Your_Receipt_Handle&lt;/replaceable&gt;</code>
 * </p>
 * <p>
 * <code>&amp;amp;ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout=45</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeMessageVisibilityBatchRequestEntry implements
        ToCopyableBuilder<ChangeMessageVisibilityBatchRequestEntry.Builder, ChangeMessageVisibilityBatchRequestEntry> {
    private final String id;

    private final String receiptHandle;

    private final Integer visibilityTimeout;

    private ChangeMessageVisibilityBatchRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.receiptHandle = builder.receiptHandle;
        this.visibilityTimeout = builder.visibilityTimeout;
    }

    /**
     * <p>
     * An identifier for this particular receipt handle used to communicate the result.
     * </p>
     * <note>
     * <p>
     * The <code>Id</code>s of a batch request need to be unique within a request
     * </p>
     * </note>
     * 
     * @return An identifier for this particular receipt handle used to communicate the result.</p> <note>
     *         <p>
     *         The <code>Id</code>s of a batch request need to be unique within a request
     *         </p>
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A receipt handle.
     * </p>
     * 
     * @return A receipt handle.
     */
    public String receiptHandle() {
        return receiptHandle;
    }

    /**
     * <p>
     * The new value (in seconds) for the message's visibility timeout.
     * </p>
     * 
     * @return The new value (in seconds) for the message's visibility timeout.
     */
    public Integer visibilityTimeout() {
        return visibilityTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((receiptHandle() == null) ? 0 : receiptHandle().hashCode());
        hashCode = 31 * hashCode + ((visibilityTimeout() == null) ? 0 : visibilityTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchRequestEntry)) {
            return false;
        }
        ChangeMessageVisibilityBatchRequestEntry other = (ChangeMessageVisibilityBatchRequestEntry) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.receiptHandle() == null ^ this.receiptHandle() == null) {
            return false;
        }
        if (other.receiptHandle() != null && !other.receiptHandle().equals(this.receiptHandle())) {
            return false;
        }
        if (other.visibilityTimeout() == null ^ this.visibilityTimeout() == null) {
            return false;
        }
        if (other.visibilityTimeout() != null && !other.visibilityTimeout().equals(this.visibilityTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (receiptHandle() != null) {
            sb.append("ReceiptHandle: ").append(receiptHandle()).append(",");
        }
        if (visibilityTimeout() != null) {
            sb.append("VisibilityTimeout: ").append(visibilityTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeMessageVisibilityBatchRequestEntry> {
        /**
         * <p>
         * An identifier for this particular receipt handle used to communicate the result.
         * </p>
         * <note>
         * <p>
         * The <code>Id</code>s of a batch request need to be unique within a request
         * </p>
         * </note>
         * 
         * @param id
         *        An identifier for this particular receipt handle used to communicate the result.</p> <note>
         *        <p>
         *        The <code>Id</code>s of a batch request need to be unique within a request
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A receipt handle.
         * </p>
         * 
         * @param receiptHandle
         *        A receipt handle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);

        /**
         * <p>
         * The new value (in seconds) for the message's visibility timeout.
         * </p>
         * 
         * @param visibilityTimeout
         *        The new value (in seconds) for the message's visibility timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityTimeout(Integer visibilityTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String receiptHandle;

        private Integer visibilityTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchRequestEntry model) {
            setId(model.id);
            setReceiptHandle(model.receiptHandle);
            setVisibilityTimeout(model.visibilityTimeout);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final Integer getVisibilityTimeout() {
            return visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public ChangeMessageVisibilityBatchRequestEntry build() {
            return new ChangeMessageVisibilityBatchRequestEntry(this);
        }
    }
}
