/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For each message in the batch, the response contains a <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code>
 * tag if the message succeeds or a <code> <a>BatchResultErrorEntry</a> </code> tag if the message fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeMessageVisibilityBatchResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ChangeMessageVisibilityBatchResponse.Builder, ChangeMessageVisibilityBatchResponse> {
    private final List<ChangeMessageVisibilityBatchResultEntry> successful;

    private final List<BatchResultErrorEntry> failed;

    private ChangeMessageVisibilityBatchResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * <p>
     * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
     */
    public List<ChangeMessageVisibilityBatchResultEntry> successful() {
        return successful;
    }

    /**
     * <p>
     * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>BatchResultErrorEntry</a> </code> items.
     */
    public List<BatchResultErrorEntry> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((successful() == null) ? 0 : successful().hashCode());
        hashCode = 31 * hashCode + ((failed() == null) ? 0 : failed().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchResponse)) {
            return false;
        }
        ChangeMessageVisibilityBatchResponse other = (ChangeMessageVisibilityBatchResponse) obj;
        if (other.successful() == null ^ this.successful() == null) {
            return false;
        }
        if (other.successful() != null && !other.successful().equals(this.successful())) {
            return false;
        }
        if (other.failed() == null ^ this.failed() == null) {
            return false;
        }
        if (other.failed() != null && !other.failed().equals(this.failed())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (successful() != null) {
            sb.append("Successful: ").append(successful()).append(",");
        }
        if (failed() != null) {
            sb.append("Failed: ").append(failed()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeMessageVisibilityBatchResponse> {
        /**
         * <p>
         * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<ChangeMessageVisibilityBatchResultEntry> successful);

        /**
         * <p>
         * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(ChangeMessageVisibilityBatchResultEntry... successful);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchResultErrorEntry> failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchResultErrorEntry... failed);
    }

    private static final class BuilderImpl implements Builder {
        private List<ChangeMessageVisibilityBatchResultEntry> successful;

        private List<BatchResultErrorEntry> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchResponse model) {
            setSuccessful(model.successful);
            setFailed(model.failed);
        }

        public final Collection<ChangeMessageVisibilityBatchResultEntry> getSuccessful() {
            return successful;
        }

        @Override
        public final Builder successful(Collection<ChangeMessageVisibilityBatchResultEntry> successful) {
            this.successful = ChangeMessageVisibilityBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(ChangeMessageVisibilityBatchResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<ChangeMessageVisibilityBatchResultEntry> successful) {
            this.successful = ChangeMessageVisibilityBatchResultEntryListCopier.copy(successful);
        }

        public final Collection<BatchResultErrorEntry> getFailed() {
            return failed;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
        }

        @Override
        public ChangeMessageVisibilityBatchResponse build() {
            return new ChangeMessageVisibilityBatchResponse(this);
        }
    }
}
