/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMessageBatchRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteMessageBatchRequest.Builder, DeleteMessageBatchRequest> {
    private final String queueUrl;

    private final List<DeleteMessageBatchRequestEntry> entries;

    private DeleteMessageBatchRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue from which messages are deleted.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue from which messages are deleted.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of receipt handles for the messages to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of receipt handles for the messages to be deleted.
     */
    public List<DeleteMessageBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((entries() == null) ? 0 : entries().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequest)) {
            return false;
        }
        DeleteMessageBatchRequest other = (DeleteMessageBatchRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (entries() != null) {
            sb.append("Entries: ").append(entries()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteMessageBatchRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue from which messages are deleted.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue from which messages are deleted.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of receipt handles for the messages to be deleted.
         * </p>
         * 
         * @param entries
         *        A list of receipt handles for the messages to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<DeleteMessageBatchRequestEntry> entries);

        /**
         * <p>
         * A list of receipt handles for the messages to be deleted.
         * </p>
         * 
         * @param entries
         *        A list of receipt handles for the messages to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(DeleteMessageBatchRequestEntry... entries);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private List<DeleteMessageBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchRequest model) {
            setQueueUrl(model.queueUrl);
            setEntries(model.entries);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<DeleteMessageBatchRequestEntry> getEntries() {
            return entries;
        }

        @Override
        public final Builder entries(Collection<DeleteMessageBatchRequestEntry> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(DeleteMessageBatchRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copy(entries);
        }

        @Override
        public DeleteMessageBatchRequest build() {
            return new DeleteMessageBatchRequest(this);
        }
    }
}
