/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetQueueAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetQueueAttributesRequest.Builder, GetQueueAttributesRequest> {
    private final String queueUrl;

    private final List<String> attributeNames;

    private GetQueueAttributesRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue whose attribute information is retrieved.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue whose attribute information is retrieved.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of attributes for which to retrieve information.
     * </p>
     * <note>
     * <p>
     * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
     * structure your code so that it can handle new attributes gracefully.
     * </p>
     * </note>
     * <p>
     * The following attributes are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>All</code> - Returns all values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a queue. For
     * more information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
     * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are waiting to
     * be added to the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that have not
     * timed-out and aren't deleted. For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
     * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before Amazon SQS
     * rejects it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS retains a
     * message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Policy</code> - Returns the policy of the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
     * <code>ReceiveMessage</code> action waits for a message to arrive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source queue. For
     * more information about the redrive policy and dead letter queues, see <a
     * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
     * >Using Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information about the
     * visibility timeout, see <a
     * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
     * >server-side-encryption</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon SQS or a
     * custom CMK. For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
     * >Key Terms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon SQS can
     * reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
     * (first-in-first-out) queues</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
     * >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * To determine whether a queue is <a
     * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>, you
     * can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for the queue.
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
     * >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of attributes for which to retrieve information.</p> <note>
     *         <p>
     *         In the future, new attributes might be added. If you write code that calls this action, we recommend that
     *         you structure your code so that it can handle new attributes gracefully.
     *         </p>
     *         </note>
     *         <p>
     *         The following attributes are supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>All</code> - Returns all values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a queue.
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
     *         >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are
     *         waiting to be added to the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that have
     *         not timed-out and aren't deleted. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
     *         >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before Amazon
     *         SQS rejects it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS
     *         retains a message.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Policy</code> - Returns the policy of the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
     *         <code>ReceiveMessage</code> action waits for a message to arrive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source
     *         queue. For more information about the redrive policy and dead letter queues, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
     *         >Using Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information about
     *         the visibility timeout, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     *         >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
     *         >server-side-encryption</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon SQS
     *         or a custom CMK. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
     *         >Key Terms</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon SQS
     *         can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a
     *         href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
     *         (first-in-first-out) queues</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
     *         >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         To determine whether a queue is <a
     *         href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
     *         >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for the
     *         queue. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
     *         >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     * @see QueueAttributeName
     */
    public List<String> attributeNames() {
        return attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((attributeNames() == null) ? 0 : attributeNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.attributeNames() == null ^ this.attributeNames() == null) {
            return false;
        }
        if (other.attributeNames() != null && !other.attributeNames().equals(this.attributeNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (attributeNames() != null) {
            sb.append("AttributeNames: ").append(attributeNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetQueueAttributesRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue whose attribute information is retrieved.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue whose attribute information is retrieved.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> - Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a queue. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are waiting
         * to be added to the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that have not
         * timed-out and aren't deleted. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS retains a
         * message.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> - Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source queue.
         * For more information about the redrive policy and dead letter queues, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Using
         * Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon SQS or a
         * custom CMK. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
         * >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         * >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p> <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> - Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a
         *        queue. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         *        >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are
         *        waiting to be added to the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that
         *        have not timed-out and aren't deleted. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         *        >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> - Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source
         *        queue. For more information about the redrive policy and dead letter queues, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >Using Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon
         *        SQS or a custom CMK. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         *        (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
         *        >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         *        >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         * @see QueueAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueAttributeName
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> - Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a queue. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are waiting
         * to be added to the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that have not
         * timed-out and aren't deleted. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS retains a
         * message.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> - Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source queue.
         * For more information about the redrive policy and dead letter queues, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Using
         * Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon SQS or a
         * custom CMK. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
         * >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         * >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p> <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> - Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a
         *        queue. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         *        >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are
         *        waiting to be added to the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that
         *        have not timed-out and aren't deleted. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         *        >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> - Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source
         *        queue. For more information about the redrive policy and dead letter queues, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >Using Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon
         *        SQS or a custom CMK. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         *        (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
         *        >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         *        >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         * @see QueueAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueAttributeName
         */
        Builder attributeNames(String... attributeNames);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> - Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a queue. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are waiting
         * to be added to the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that have not
         * timed-out and aren't deleted. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         * >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS retains a
         * message.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> - Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source queue.
         * For more information about the redrive policy and dead letter queues, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Using
         * Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon SQS or a
         * custom CMK. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
         * >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         * >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p> <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> - Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> - Returns the approximate number of visible messages in a
         *        queue. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         *        >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> - Returns the approximate number of messages that are
         *        waiting to be added to the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> - Returns the approximate number of messages that
         *        have not timed-out and aren't deleted. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-resources-required-process-messages.html"
         *        >Resources Required to Process Messages</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> - Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> - Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> - Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> - Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> - Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> - Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> - Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> - Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> - Returns the parameters for dead letter queue functionality of the source
         *        queue. For more information about the redrive policy and dead letter queues, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >Using Amazon SQS Dead Letter Queues</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> - Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> - Returns the ID of an AWS-managed customer master key (CMK) for Amazon
         *        SQS or a custom CMK. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> - Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         *        (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> - Returns whether the queue is FIFO. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic"
         *        >FIFO Queue Logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> - Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         *        >Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         * @see QueueAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueAttributeName
         */
        Builder attributeNames(QueueAttributeName... attributeNames);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private List<String> attributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesRequest model) {
            setQueueUrl(model.queueUrl);
            setAttributeNames(model.attributeNames);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(QueueAttributeName... attributeNames) {
            attributeNames(Arrays.asList(attributeNames).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public GetQueueAttributesRequest build() {
            return new GetQueueAttributesRequest(this);
        }
    }
}
