/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of your queues.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListQueuesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListQueuesResponse.Builder, ListQueuesResponse> {
    private final List<String> queueUrls;

    private ListQueuesResponse(BuilderImpl builder) {
        this.queueUrls = builder.queueUrls;
    }

    /**
     * <p>
     * A list of queue URLs, up to 1,000 entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of queue URLs, up to 1,000 entries.
     */
    public List<String> queueUrls() {
        return queueUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrls() == null) ? 0 : queueUrls().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse) obj;
        if (other.queueUrls() == null ^ this.queueUrls() == null) {
            return false;
        }
        if (other.queueUrls() != null && !other.queueUrls().equals(this.queueUrls())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrls() != null) {
            sb.append("QueueUrls: ").append(queueUrls()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListQueuesResponse> {
        /**
         * <p>
         * A list of queue URLs, up to 1,000 entries.
         * </p>
         * 
         * @param queueUrls
         *        A list of queue URLs, up to 1,000 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrls(Collection<String> queueUrls);

        /**
         * <p>
         * A list of queue URLs, up to 1,000 entries.
         * </p>
         * 
         * @param queueUrls
         *        A list of queue URLs, up to 1,000 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrls(String... queueUrls);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> queueUrls;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            setQueueUrls(model.queueUrls);
        }

        public final Collection<String> getQueueUrls() {
            return queueUrls;
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String... queueUrls) {
            queueUrls(Arrays.asList(queueUrls));
            return this;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }
    }
}
