/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;

@Generated("software.amazon.awssdk:codegen")
final class MessageBodyAttributeMapCopier {
    static Map<String, MessageAttributeValue> copy(Map<String, MessageAttributeValue> messageBodyAttributeMapParam) {
        if (messageBodyAttributeMapParam == null) {
            return null;
        }
        Map<String, MessageAttributeValue> messageBodyAttributeMapParamCopy = new HashMap<>(messageBodyAttributeMapParam.size());
        for (Map.Entry<String, MessageAttributeValue> e : messageBodyAttributeMapParam.entrySet()) {
            messageBodyAttributeMapParamCopy.put(StandardMemberCopier.copy(e.getKey()), e.getValue());
        }
        return Collections.unmodifiableMap(messageBodyAttributeMapParamCopy);
    }
}
