/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>MD5OfMessageBody</code> and <code>MessageId</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SendMessageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<SendMessageResponse.Builder, SendMessageResponse> {
    private final String md5OfMessageBody;

    private final String md5OfMessageAttributes;

    private final String messageId;

    private final String sequenceNumber;

    private SendMessageResponse(BuilderImpl builder) {
        this.md5OfMessageBody = builder.md5OfMessageBody;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.messageId = builder.messageId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon
     * SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
     *         Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
     *         digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public String md5OfMessageBody() {
        return md5OfMessageBody;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon
     * SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
     *         Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
     *         digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public String md5OfMessageAttributes() {
        return md5OfMessageAttributes;
    }

    /**
     * <p>
     * An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information, see <a
     * href
     * ="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
     * >Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * 
     * @return An attribute containing the <code>MessageId</code> of the message sent to the queue. For more
     *         information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
     *         >Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
     */
    public String messageId() {
        return messageId;
    }

    /**
     * <p>
     * This parameter applies only to FIFO (first-in-first-out) queues.
     * </p>
     * <p>
     * The large, non-consecutive number that Amazon SQS assigns to each message.
     * </p>
     * <p>
     * The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a
     * particular <code>MessageGroupId</code>.
     * </p>
     * 
     * @return This parameter applies only to FIFO (first-in-first-out) queues.</p>
     *         <p>
     *         The large, non-consecutive number that Amazon SQS assigns to each message.
     *         </p>
     *         <p>
     *         The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase
     *         for a particular <code>MessageGroupId</code>.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((md5OfMessageBody() == null) ? 0 : md5OfMessageBody().hashCode());
        hashCode = 31 * hashCode + ((md5OfMessageAttributes() == null) ? 0 : md5OfMessageAttributes().hashCode());
        hashCode = 31 * hashCode + ((messageId() == null) ? 0 : messageId().hashCode());
        hashCode = 31 * hashCode + ((sequenceNumber() == null) ? 0 : sequenceNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageResponse)) {
            return false;
        }
        SendMessageResponse other = (SendMessageResponse) obj;
        if (other.md5OfMessageBody() == null ^ this.md5OfMessageBody() == null) {
            return false;
        }
        if (other.md5OfMessageBody() != null && !other.md5OfMessageBody().equals(this.md5OfMessageBody())) {
            return false;
        }
        if (other.md5OfMessageAttributes() == null ^ this.md5OfMessageAttributes() == null) {
            return false;
        }
        if (other.md5OfMessageAttributes() != null && !other.md5OfMessageAttributes().equals(this.md5OfMessageAttributes())) {
            return false;
        }
        if (other.messageId() == null ^ this.messageId() == null) {
            return false;
        }
        if (other.messageId() != null && !other.messageId().equals(this.messageId())) {
            return false;
        }
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        if (other.sequenceNumber() != null && !other.sequenceNumber().equals(this.sequenceNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (md5OfMessageBody() != null) {
            sb.append("MD5OfMessageBody: ").append(md5OfMessageBody()).append(",");
        }
        if (md5OfMessageAttributes() != null) {
            sb.append("MD5OfMessageAttributes: ").append(md5OfMessageAttributes()).append(",");
        }
        if (messageId() != null) {
            sb.append("MessageId: ").append(messageId()).append(",");
        }
        if (sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(sequenceNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SendMessageResponse> {
        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
         * Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.
         * For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageBody
         *        An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify
         *        that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the
         *        MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageBody(String md5OfMessageBody);

        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
         * Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.
         * For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageAttributes
         *        An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify
         *        that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the
         *        MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageAttributes(String md5OfMessageAttributes);

        /**
         * <p>
         * An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information,
         * see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
         * >Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param messageId
         *        An attribute containing the <code>MessageId</code> of the message sent to the queue. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
         *        >Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * </p>
         * <p>
         * The large, non-consecutive number that Amazon SQS assigns to each message.
         * </p>
         * <p>
         * The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for
         * a particular <code>MessageGroupId</code>.
         * </p>
         * 
         * @param sequenceNumber
         *        This parameter applies only to FIFO (first-in-first-out) queues.</p>
         *        <p>
         *        The large, non-consecutive number that Amazon SQS assigns to each message.
         *        </p>
         *        <p>
         *        The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to
         *        increase for a particular <code>MessageGroupId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);
    }

    private static final class BuilderImpl implements Builder {
        private String md5OfMessageBody;

        private String md5OfMessageAttributes;

        private String messageId;

        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageResponse model) {
            setMD5OfMessageBody(model.md5OfMessageBody);
            setMD5OfMessageAttributes(model.md5OfMessageAttributes);
            setMessageId(model.messageId);
            setSequenceNumber(model.sequenceNumber);
        }

        public final String getMD5OfMessageBody() {
            return md5OfMessageBody;
        }

        @Override
        public final Builder md5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
            return this;
        }

        public final void setMD5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
        }

        public final String getMD5OfMessageAttributes() {
            return md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final void setMD5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public SendMessageResponse build() {
            return new SendMessageResponse(this);
        }
    }
}
