/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * ChangeMessageVisibilityBatchRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ChangeMessageVisibilityBatchRequestMarshaller implements
        Marshaller<Request<ChangeMessageVisibilityBatchRequest>, ChangeMessageVisibilityBatchRequest> {

    public Request<ChangeMessageVisibilityBatchRequest> marshall(
            ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {

        if (changeMessageVisibilityBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ChangeMessageVisibilityBatchRequest> request = new DefaultRequest<ChangeMessageVisibilityBatchRequest>(
                changeMessageVisibilityBatchRequest, "SQSClient");
        request.addParameter("Action", "ChangeMessageVisibilityBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (changeMessageVisibilityBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(changeMessageVisibilityBatchRequest.queueUrl()));
        }

        java.util.List<ChangeMessageVisibilityBatchRequestEntry> entriesList = changeMessageVisibilityBatchRequest.entries();

        if (entriesList != null) {
            if (!entriesList.isEmpty()) {
                int entriesListIndex = 1;

                for (ChangeMessageVisibilityBatchRequestEntry entriesListValue : entriesList) {

                    if (entriesListValue.id() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".Id",
                                StringUtils.fromString(entriesListValue.id()));
                    }

                    if (entriesListValue.receiptHandle() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".ReceiptHandle",
                                StringUtils.fromString(entriesListValue.receiptHandle()));
                    }

                    if (entriesListValue.visibilityTimeout() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex
                                + ".VisibilityTimeout", StringUtils.fromInteger(entriesListValue.visibilityTimeout()));
                    }
                    entriesListIndex++;
                }
            } else {
                request.addParameter("ChangeMessageVisibilityBatchRequestEntry", "");
            }
        }

        return request;
    }

}
