/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Message
implements ToCopyableBuilder<Builder, Message> {
    private final String messageId;
    private final String receiptHandle;
    private final String md5OfBody;
    private final String body;
    private final Map<String, String> attributes;
    private final String md5OfMessageAttributes;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private Message(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.receiptHandle = builder.receiptHandle;
        this.md5OfBody = builder.md5OfBody;
        this.body = builder.body;
        this.attributes = builder.attributes;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.messageAttributes = builder.messageAttributes;
    }

    public String messageId() {
        return this.messageId;
    }

    public String receiptHandle() {
        return this.receiptHandle;
    }

    public String md5OfBody() {
        return this.md5OfBody;
    }

    public String body() {
        return this.body;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String md5OfMessageAttributes() {
        return this.md5OfMessageAttributes;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messageId() == null ? 0 : this.messageId().hashCode());
        hashCode = 31 * hashCode + (this.receiptHandle() == null ? 0 : this.receiptHandle().hashCode());
        hashCode = 31 * hashCode + (this.md5OfBody() == null ? 0 : this.md5OfBody().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.md5OfMessageAttributes() == null ? 0 : this.md5OfMessageAttributes().hashCode());
        hashCode = 31 * hashCode + (this.messageAttributes() == null ? 0 : this.messageAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.messageId() == null ^ this.messageId() == null) {
            return false;
        }
        if (other.messageId() != null && !other.messageId().equals(this.messageId())) {
            return false;
        }
        if (other.receiptHandle() == null ^ this.receiptHandle() == null) {
            return false;
        }
        if (other.receiptHandle() != null && !other.receiptHandle().equals(this.receiptHandle())) {
            return false;
        }
        if (other.md5OfBody() == null ^ this.md5OfBody() == null) {
            return false;
        }
        if (other.md5OfBody() != null && !other.md5OfBody().equals(this.md5OfBody())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.md5OfMessageAttributes() == null ^ this.md5OfMessageAttributes() == null) {
            return false;
        }
        if (other.md5OfMessageAttributes() != null && !other.md5OfMessageAttributes().equals(this.md5OfMessageAttributes())) {
            return false;
        }
        if (other.messageAttributes() == null ^ this.messageAttributes() == null) {
            return false;
        }
        return other.messageAttributes() == null || other.messageAttributes().equals(this.messageAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.messageId() != null) {
            sb.append("MessageId: ").append(this.messageId()).append(",");
        }
        if (this.receiptHandle() != null) {
            sb.append("ReceiptHandle: ").append(this.receiptHandle()).append(",");
        }
        if (this.md5OfBody() != null) {
            sb.append("MD5OfBody: ").append(this.md5OfBody()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.md5OfMessageAttributes() != null) {
            sb.append("MD5OfMessageAttributes: ").append(this.md5OfMessageAttributes()).append(",");
        }
        if (this.messageAttributes() != null) {
            sb.append("MessageAttributes: ").append(this.messageAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String receiptHandle;
        private String md5OfBody;
        private String body;
        private Map<String, String> attributes;
        private String md5OfMessageAttributes;
        private Map<String, MessageAttributeValue> messageAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.setMessageId(model.messageId);
            this.setReceiptHandle(model.receiptHandle);
            this.setMD5OfBody(model.md5OfBody);
            this.setBody(model.body);
            this.setAttributes(model.attributes);
            this.setMD5OfMessageAttributes(model.md5OfMessageAttributes);
            this.setMessageAttributes(model.messageAttributes);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getReceiptHandle() {
            return this.receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final String getMD5OfBody() {
            return this.md5OfBody;
        }

        @Override
        public final Builder md5OfBody(String md5OfBody) {
            this.md5OfBody = md5OfBody;
            return this;
        }

        public final void setMD5OfBody(String md5OfBody) {
            this.md5OfBody = md5OfBody;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copy(attributes);
        }

        public final String getMD5OfMessageAttributes() {
            return this.md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final void setMD5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        public final Map<String, MessageAttributeValue> getMessageAttributes() {
            return this.messageAttributes;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Message> {
        public Builder messageId(String var1);

        public Builder receiptHandle(String var1);

        public Builder md5OfBody(String var1);

        public Builder body(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder md5OfMessageAttributes(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);
    }
}

