/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.util.StringUtils;

public class ChangeMessageVisibilityBatchRequestMarshaller
implements Marshaller<Request<ChangeMessageVisibilityBatchRequest>, ChangeMessageVisibilityBatchRequest> {
    public Request<ChangeMessageVisibilityBatchRequest> marshall(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        List<ChangeMessageVisibilityBatchRequestEntry> entriesList;
        if (changeMessageVisibilityBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeMessageVisibilityBatchRequest, "SQSClient");
        request.addParameter("Action", "ChangeMessageVisibilityBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (changeMessageVisibilityBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)changeMessageVisibilityBatchRequest.queueUrl()));
        }
        if ((entriesList = changeMessageVisibilityBatchRequest.entries()) != null) {
            if (!entriesList.isEmpty()) {
                int entriesListIndex = 1;
                for (ChangeMessageVisibilityBatchRequestEntry entriesListValue : entriesList) {
                    if (entriesListValue.id() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString((String)entriesListValue.id()));
                    }
                    if (entriesListValue.receiptHandle() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringUtils.fromString((String)entriesListValue.receiptHandle()));
                    }
                    if (entriesListValue.visibilityTimeout() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".VisibilityTimeout", StringUtils.fromInteger((Integer)entriesListValue.visibilityTimeout()));
                    }
                    ++entriesListIndex;
                }
            } else {
                request.addParameter("ChangeMessageVisibilityBatchRequestEntry", "");
            }
        }
        return request;
    }
}

