/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.util.StringUtils;

public class PurgeQueueRequestMarshaller
implements Marshaller<Request<PurgeQueueRequest>, PurgeQueueRequest> {
    public Request<PurgeQueueRequest> marshall(PurgeQueueRequest purgeQueueRequest) {
        if (purgeQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purgeQueueRequest, "SQSClient");
        request.addParameter("Action", "PurgeQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (purgeQueueRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)purgeQueueRequest.queueUrl()));
        }
        return request;
    }
}

