/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ChangeMessageVisibilityBatchResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ChangeMessageVisibilityBatchResponseUnmarshaller implements
        Unmarshaller<ChangeMessageVisibilityBatchResponse, StaxUnmarshallerContext> {

    public ChangeMessageVisibilityBatchResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ChangeMessageVisibilityBatchResponse.Builder changeMessageVisibilityBatchResponse = ChangeMessageVisibilityBatchResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<ChangeMessageVisibilityBatchResultEntry> successful = null;
        java.util.List<BatchResultErrorEntry> failed = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                changeMessageVisibilityBatchResponse.successful(successful);
                changeMessageVisibilityBatchResponse.failed(failed);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("ChangeMessageVisibilityBatchResultEntry", targetDepth)) {
                    if (successful == null) {
                        successful = new ArrayList<>();
                    }
                    successful.add(ChangeMessageVisibilityBatchResultEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BatchResultErrorEntry", targetDepth)) {
                    if (failed == null) {
                        failed = new ArrayList<>();
                    }
                    failed.add(BatchResultErrorEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    changeMessageVisibilityBatchResponse.successful(successful);
                    changeMessageVisibilityBatchResponse.failed(failed);
                    break;
                }
            }
        }
        return changeMessageVisibilityBatchResponse.build();
    }

    private static final ChangeMessageVisibilityBatchResponseUnmarshaller INSTANCE = new ChangeMessageVisibilityBatchResponseUnmarshaller();

    public static ChangeMessageVisibilityBatchResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
