/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * GetQueueAttributesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetQueueAttributesRequestMarshaller implements
        Marshaller<Request<GetQueueAttributesRequest>, GetQueueAttributesRequest> {

    public Request<GetQueueAttributesRequest> marshall(GetQueueAttributesRequest getQueueAttributesRequest) {

        if (getQueueAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetQueueAttributesRequest> request = new DefaultRequest<GetQueueAttributesRequest>(getQueueAttributesRequest,
                "SQSClient");
        request.addParameter("Action", "GetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (getQueueAttributesRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(getQueueAttributesRequest.queueUrl()));
        }

        java.util.List<String> attributeNamesList = getQueueAttributesRequest.attributeNamesStrings();

        if (attributeNamesList != null) {
            if (!attributeNamesList.isEmpty()) {
                int attributeNamesListIndex = 1;

                for (String attributeNamesListValue : attributeNamesList) {
                    if (attributeNamesListValue != null) {
                        request.addParameter("AttributeName." + attributeNamesListIndex,
                                StringUtils.fromString(attributeNamesListValue));
                    }
                    attributeNamesListIndex++;
                }
            } else {
                request.addParameter("AttributeName", "");
            }
        }

        return request;
    }

}
