/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteMessageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteMessageRequest> {
    private final String queueUrl;
    private final String receiptHandle;

    private DeleteMessageRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.receiptHandle = builder.receiptHandle;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String receiptHandle() {
        return this.receiptHandle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptHandle());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageRequest)) {
            return false;
        }
        DeleteMessageRequest other = (DeleteMessageRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.receiptHandle(), other.receiptHandle());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.receiptHandle() != null) {
            sb.append("ReceiptHandle: ").append(this.receiptHandle()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "ReceiptHandle": {
                return Optional.of(clazz.cast(this.receiptHandle()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private String receiptHandle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageRequest model) {
            this.queueUrl(model.queueUrl);
            this.receiptHandle(model.receiptHandle);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getReceiptHandle() {
            return this.receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public DeleteMessageRequest build() {
            return new DeleteMessageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteMessageRequest> {
        public Builder queueUrl(String var1);

        public Builder receiptHandle(String var1);
    }
}

