/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.UntagQueueRequest;

public class UntagQueueRequestMarshaller
implements Marshaller<Request<UntagQueueRequest>, UntagQueueRequest> {
    public Request<UntagQueueRequest> marshall(UntagQueueRequest untagQueueRequest) {
        List<String> tagKeysList;
        if (untagQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)untagQueueRequest, "SQSClient");
        request.addParameter("Action", "UntagQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (untagQueueRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)untagQueueRequest.queueUrl()));
        }
        if ((tagKeysList = untagQueueRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKey", "");
            }
        }
        return request;
    }
}

