/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Message
implements ToCopyableBuilder<Builder, Message> {
    private final String messageId;
    private final String receiptHandle;
    private final String md5OfBody;
    private final String body;
    private final Map<String, String> attributes;
    private final String md5OfMessageAttributes;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private Message(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.receiptHandle = builder.receiptHandle;
        this.md5OfBody = builder.md5OfBody;
        this.body = builder.body;
        this.attributes = builder.attributes;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.messageAttributes = builder.messageAttributes;
    }

    public String messageId() {
        return this.messageId;
    }

    public String receiptHandle() {
        return this.receiptHandle;
    }

    public String md5OfBody() {
        return this.md5OfBody;
    }

    public String body() {
        return this.body;
    }

    public Map<MessageSystemAttributeName, String> attributes() {
        return TypeConverter.convert(this.attributes, MessageSystemAttributeName::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)MessageSystemAttributeName.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesStrings() {
        return this.attributes;
    }

    public String md5OfMessageAttributes() {
        return this.md5OfMessageAttributes;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.receiptHandle(), other.receiptHandle()) && Objects.equals(this.md5OfBody(), other.md5OfBody()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.attributesStrings(), other.attributesStrings()) && Objects.equals(this.md5OfMessageAttributes(), other.md5OfMessageAttributes()) && Objects.equals(this.messageAttributes(), other.messageAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.messageId() != null) {
            sb.append("MessageId: ").append(this.messageId()).append(",");
        }
        if (this.receiptHandle() != null) {
            sb.append("ReceiptHandle: ").append(this.receiptHandle()).append(",");
        }
        if (this.md5OfBody() != null) {
            sb.append("MD5OfBody: ").append(this.md5OfBody()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.attributesStrings() != null) {
            sb.append("Attributes: ").append(this.attributesStrings()).append(",");
        }
        if (this.md5OfMessageAttributes() != null) {
            sb.append("MD5OfMessageAttributes: ").append(this.md5OfMessageAttributes()).append(",");
        }
        if (this.messageAttributes() != null) {
            sb.append("MessageAttributes: ").append(this.messageAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.of(clazz.cast(this.messageId()));
            }
            case "ReceiptHandle": {
                return Optional.of(clazz.cast(this.receiptHandle()));
            }
            case "MD5OfBody": {
                return Optional.of(clazz.cast(this.md5OfBody()));
            }
            case "Body": {
                return Optional.of(clazz.cast(this.body()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesStrings()));
            }
            case "MD5OfMessageAttributes": {
                return Optional.of(clazz.cast(this.md5OfMessageAttributes()));
            }
            case "MessageAttributes": {
                return Optional.of(clazz.cast(this.messageAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String receiptHandle;
        private String md5OfBody;
        private String body;
        private Map<String, String> attributes;
        private String md5OfMessageAttributes;
        private Map<String, MessageAttributeValue> messageAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.messageId(model.messageId);
            this.receiptHandle(model.receiptHandle);
            this.md5OfBody(model.md5OfBody);
            this.body(model.body);
            this.attributes(model.attributes);
            this.md5OfMessageAttributes(model.md5OfMessageAttributes);
            this.messageAttributes(model.messageAttributes);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getReceiptHandle() {
            return this.receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final String getMD5OfBody() {
            return this.md5OfBody;
        }

        @Override
        public final Builder md5OfBody(String md5OfBody) {
            this.md5OfBody = md5OfBody;
            return this;
        }

        public final void setMD5OfBody(String md5OfBody) {
            this.md5OfBody = md5OfBody;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copy(attributes);
        }

        public final String getMD5OfMessageAttributes() {
            return this.md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final void setMD5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return this.messageAttributes != null ? CollectionUtils.mapValues(this.messageAttributes, MessageAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Message> {
        public Builder messageId(String var1);

        public Builder receiptHandle(String var1);

        public Builder md5OfBody(String var1);

        public Builder body(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder md5OfMessageAttributes(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);
    }
}

