/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

public class MessageAttributeValueUnmarshaller
implements Unmarshaller<MessageAttributeValue, StaxUnmarshallerContext> {
    private static final MessageAttributeValueUnmarshaller INSTANCE = new MessageAttributeValueUnmarshaller();

    public MessageAttributeValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageAttributeValue.Builder messageAttributeValue;
        block10: {
            messageAttributeValue = MessageAttributeValue.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> stringListValues = null;
            ArrayList<ByteBuffer> binaryListValues = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    messageAttributeValue.stringListValues(stringListValues);
                    messageAttributeValue.binaryListValues(binaryListValues);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("StringValue", targetDepth)) {
                        messageAttributeValue.stringValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BinaryValue", targetDepth)) {
                        messageAttributeValue.binaryValue(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StringListValue", targetDepth)) {
                        if (stringListValues == null) {
                            stringListValues = new ArrayList<String>();
                        }
                        stringListValues.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BinaryListValue", targetDepth)) {
                        if (binaryListValues == null) {
                            binaryListValues = new ArrayList<ByteBuffer>();
                        }
                        binaryListValues.add(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("DataType", targetDepth)) continue;
                    messageAttributeValue.dataType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            messageAttributeValue.stringListValues(stringListValues);
            messageAttributeValue.binaryListValues(binaryListValues);
        }
        return (MessageAttributeValue)messageAttributeValue.build();
    }

    public static MessageAttributeValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}

