/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        if (removePermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)removePermissionRequest, "SQSClient");
        request.addParameter("Action", "RemovePermission");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (removePermissionRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)removePermissionRequest.queueUrl()));
        }
        if (removePermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString((String)removePermissionRequest.label()));
        }
        return request;
    }
}

