/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddPermissionRequest extends SQSRequest implements
        ToCopyableBuilder<AddPermissionRequest.Builder, AddPermissionRequest> {
    private final String queueUrl;

    private final String label;

    private final List<String> awsAccountIds;

    private final List<String> actions;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue to which permissions are added.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue to which permissions are added.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>). Maximum
     * 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and underscores (
     * <code>_</code>).
     * </p>
     * 
     * @return The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>).
     *         Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and
     *         underscores (<code>_</code>).
     */
    public String label() {
        return label;
    }

    /**
     * <p>
     * The AWS account number of the <a
     * href="http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a> who is given permission. The
     * principal must have an AWS account, but does not need to be signed up for Amazon SQS. For information about
     * locating the AWS account identification, see <a
     * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html">Your AWS
     * Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account number of the <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a> who is given
     *         permission. The principal must have an AWS account, but does not need to be signed up for Amazon SQS. For
     *         information about locating the AWS account identification, see <a
     *         href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html">Your
     *         AWS Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     */
    public List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * <p>
     * The action the client wants to allow for the specified principal. The following values are valid:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>*</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ChangeMessageVisibility</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteMessage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetQueueAttributes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetQueueUrl</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReceiveMessage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SendMessage</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about these actions, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes"
     * >Understanding Permissions</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     * </p>
     * <p>
     * Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for
     * <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions:
     * <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The action the client wants to allow for the specified principal. The following values are valid:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>*</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ChangeMessageVisibility</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteMessage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetQueueAttributes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetQueueUrl</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReceiveMessage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SendMessage</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about these actions, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes"
     *         >Understanding Permissions</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code>
     *         for <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those
     *         actions: <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and
     *         <code>ChangeMessageVisibilityBatch</code>.
     */
    public List<String> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountIds());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(label(), other.label())
                && Objects.equals(awsAccountIds(), other.awsAccountIds()) && Objects.equals(actions(), other.actions());
    }

    @Override
    public String toString() {
        return ToString.builder("AddPermissionRequest").add("QueueUrl", queueUrl()).add("Label", label())
                .add("AWSAccountIds", awsAccountIds()).add("Actions", actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "Label":
            return Optional.of(clazz.cast(label()));
        case "AWSAccountIds":
            return Optional.of(clazz.cast(awsAccountIds()));
        case "Actions":
            return Optional.of(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, AddPermissionRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue to which permissions are added.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue to which permissions are added.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>).
         * Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and
         * underscores (<code>_</code>).
         * </p>
         * 
         * @param label
         *        The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>
         *        ). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>
         *        ), and underscores (<code>_</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The AWS account number of the <a
         * href="http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a> who is given permission.
         * The principal must have an AWS account, but does not need to be signed up for Amazon SQS. For information
         * about locating the AWS account identification, see <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html">Your AWS
         * Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * 
         * @param awsAccountIds
         *        The AWS account number of the <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a> who is given
         *        permission. The principal must have an AWS account, but does not need to be signed up for Amazon SQS.
         *        For information about locating the AWS account identification, see <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html"
         *        >Your AWS Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * The AWS account number of the <a
         * href="http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a> who is given permission.
         * The principal must have an AWS account, but does not need to be signed up for Amazon SQS. For information
         * about locating the AWS account identification, see <a
         * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html">Your AWS
         * Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * 
         * @param awsAccountIds
         *        The AWS account number of the <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a> who is given
         *        permission. The principal must have an AWS account, but does not need to be signed up for Amazon SQS.
         *        For information about locating the AWS account identification, see <a
         *        href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html"
         *        >Your AWS Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The action the client wants to allow for the specified principal. The following values are valid:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>*</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ChangeMessageVisibility</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteMessage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetQueueAttributes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetQueueUrl</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SendMessage</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these actions, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes"
         * >Understanding Permissions</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * <p>
         * Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for
         * <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions:
         * <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>
         * .
         * </p>
         * 
         * @param actions
         *        The action the client wants to allow for the specified principal. The following values are valid:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>*</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ChangeMessageVisibility</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteMessage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetQueueAttributes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetQueueUrl</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SendMessage</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these actions, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes"
         *        >Understanding Permissions</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or
         *        <code>ChangeMessageVisibility</code> for <code>ActionName.n</code> also grants permissions for the
         *        corresponding batch versions of those actions: <code>SendMessageBatch</code>,
         *        <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The action the client wants to allow for the specified principal. The following values are valid:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>*</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ChangeMessageVisibility</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteMessage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetQueueAttributes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetQueueUrl</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SendMessage</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these actions, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes"
         * >Understanding Permissions</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * <p>
         * Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for
         * <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions:
         * <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>
         * .
         * </p>
         * 
         * @param actions
         *        The action the client wants to allow for the specified principal. The following values are valid:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>*</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ChangeMessageVisibility</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteMessage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetQueueAttributes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetQueueUrl</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SendMessage</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these actions, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes"
         *        >Understanding Permissions</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or
         *        <code>ChangeMessageVisibility</code> for <code>ActionName.n</code> also grants permissions for the
         *        corresponding batch versions of those actions: <code>SendMessageBatch</code>,
         *        <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private String label;

        private List<String> awsAccountIds;

        private List<String> actions;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            queueUrl(model.queueUrl);
            label(model.label);
            awsAccountIds(model.awsAccountIds);
            actions(model.actions);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getAWSAccountIds() {
            return awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final void setAWSAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
        }

        public final Collection<String> getActions() {
            return actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }
    }
}
