/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is used in the responses of batch API to give a detailed description of the result of an action on each entry in
 * the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchResultErrorEntry implements ToCopyableBuilder<BatchResultErrorEntry.Builder, BatchResultErrorEntry> {
    private final String id;

    private final Boolean senderFault;

    private final String code;

    private final String message;

    private BatchResultErrorEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.senderFault = builder.senderFault;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The <code>Id</code> of an entry in a batch request.
     * </p>
     * 
     * @return The <code>Id</code> of an entry in a batch request.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the error happened due to the sender's fault.
     * </p>
     * 
     * @return Specifies whether the error happened due to the sender's fault.
     */
    public Boolean senderFault() {
        return senderFault;
    }

    /**
     * <p>
     * An error code representing why the action failed on this entry.
     * </p>
     * 
     * @return An error code representing why the action failed on this entry.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * A message explaining why the action failed on this entry.
     * </p>
     * 
     * @return A message explaining why the action failed on this entry.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(senderFault());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchResultErrorEntry)) {
            return false;
        }
        BatchResultErrorEntry other = (BatchResultErrorEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(senderFault(), other.senderFault())
                && Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchResultErrorEntry").add("Id", id()).add("SenderFault", senderFault()).add("Code", code())
                .add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "SenderFault":
            return Optional.of(clazz.cast(senderFault()));
        case "Code":
            return Optional.of(clazz.cast(code()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, BatchResultErrorEntry> {
        /**
         * <p>
         * The <code>Id</code> of an entry in a batch request.
         * </p>
         * 
         * @param id
         *        The <code>Id</code> of an entry in a batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the error happened due to the sender's fault.
         * </p>
         * 
         * @param senderFault
         *        Specifies whether the error happened due to the sender's fault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderFault(Boolean senderFault);

        /**
         * <p>
         * An error code representing why the action failed on this entry.
         * </p>
         * 
         * @param code
         *        An error code representing why the action failed on this entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A message explaining why the action failed on this entry.
         * </p>
         * 
         * @param message
         *        A message explaining why the action failed on this entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Boolean senderFault;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchResultErrorEntry model) {
            id(model.id);
            senderFault(model.senderFault);
            code(model.code);
            message(model.message);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getSenderFault() {
            return senderFault;
        }

        @Override
        public final Builder senderFault(Boolean senderFault) {
            this.senderFault = senderFault;
            return this;
        }

        public final void setSenderFault(Boolean senderFault) {
            this.senderFault = senderFault;
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public BatchResultErrorEntry build() {
            return new BatchResultErrorEntry(this);
        }
    }
}
