/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the <code>QueueUrl</code> attribute of the created queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateQueueResponse extends SQSResponse implements
        ToCopyableBuilder<CreateQueueResponse.Builder, CreateQueueResponse> {
    private final String queueUrl;

    private CreateQueueResponse(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
    }

    /**
     * <p>
     * The URL of the created Amazon SQS queue.
     * </p>
     * 
     * @return The URL of the created Amazon SQS queue.
     */
    public String queueUrl() {
        return queueUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueResponse)) {
            return false;
        }
        CreateQueueResponse other = (CreateQueueResponse) obj;
        return Objects.equals(queueUrl(), other.queueUrl());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateQueueResponse").add("QueueUrl", queueUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, CreateQueueResponse> {
        /**
         * <p>
         * The URL of the created Amazon SQS queue.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the created Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private String queueUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueResponse model) {
            queueUrl(model.queueUrl);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public CreateQueueResponse build() {
            return new CreateQueueResponse(this);
        }
    }
}
