/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMessageBatchRequest extends SQSRequest implements
        ToCopyableBuilder<DeleteMessageBatchRequest.Builder, DeleteMessageBatchRequest> {
    private final String queueUrl;

    private final List<DeleteMessageBatchRequestEntry> entries;

    private DeleteMessageBatchRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue from which messages are deleted.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue from which messages are deleted.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of receipt handles for the messages to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of receipt handles for the messages to be deleted.
     */
    public List<DeleteMessageBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequest)) {
            return false;
        }
        DeleteMessageBatchRequest other = (DeleteMessageBatchRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(entries(), other.entries());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteMessageBatchRequest").add("QueueUrl", queueUrl()).add("Entries", entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "Entries":
            return Optional.of(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, DeleteMessageBatchRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue from which messages are deleted.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue from which messages are deleted.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of receipt handles for the messages to be deleted.
         * </p>
         * 
         * @param entries
         *        A list of receipt handles for the messages to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<DeleteMessageBatchRequestEntry> entries);

        /**
         * <p>
         * A list of receipt handles for the messages to be deleted.
         * </p>
         * 
         * @param entries
         *        A list of receipt handles for the messages to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(DeleteMessageBatchRequestEntry... entries);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private List<DeleteMessageBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchRequest model) {
            queueUrl(model.queueUrl);
            entries(model.entries);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<DeleteMessageBatchRequestEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(DeleteMessageBatchRequestEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entries(Collection<DeleteMessageBatchRequestEntry> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(DeleteMessageBatchRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<DeleteMessageBatchRequestEntry.BuilderImpl> entries) {
            this.entries = DeleteMessageBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteMessageBatchRequest build() {
            return new DeleteMessageBatchRequest(this);
        }
    }
}
