/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For each message in the batch, the response contains a <code> <a>DeleteMessageBatchResultEntry</a> </code> tag if the
 * message is deleted or a <code> <a>BatchResultErrorEntry</a> </code> tag if the message can't be deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMessageBatchResponse extends SQSResponse implements
        ToCopyableBuilder<DeleteMessageBatchResponse.Builder, DeleteMessageBatchResponse> {
    private final List<DeleteMessageBatchResultEntry> successful;

    private final List<BatchResultErrorEntry> failed;

    private DeleteMessageBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * <p>
     * A list of <code> <a>DeleteMessageBatchResultEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>DeleteMessageBatchResultEntry</a> </code> items.
     */
    public List<DeleteMessageBatchResultEntry> successful() {
        return successful;
    }

    /**
     * <p>
     * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>BatchResultErrorEntry</a> </code> items.
     */
    public List<BatchResultErrorEntry> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successful());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchResponse)) {
            return false;
        }
        DeleteMessageBatchResponse other = (DeleteMessageBatchResponse) obj;
        return Objects.equals(successful(), other.successful()) && Objects.equals(failed(), other.failed());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteMessageBatchResponse").add("Successful", successful()).add("Failed", failed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.of(clazz.cast(successful()));
        case "Failed":
            return Optional.of(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, DeleteMessageBatchResponse> {
        /**
         * <p>
         * A list of <code> <a>DeleteMessageBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>DeleteMessageBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<DeleteMessageBatchResultEntry> successful);

        /**
         * <p>
         * A list of <code> <a>DeleteMessageBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>DeleteMessageBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(DeleteMessageBatchResultEntry... successful);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchResultErrorEntry> failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchResultErrorEntry... failed);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private List<DeleteMessageBatchResultEntry> successful;

        private List<BatchResultErrorEntry> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchResponse model) {
            successful(model.successful);
            failed(model.failed);
        }

        public final Collection<DeleteMessageBatchResultEntry.Builder> getSuccessful() {
            return successful != null ? successful.stream().map(DeleteMessageBatchResultEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<DeleteMessageBatchResultEntry> successful) {
            this.successful = DeleteMessageBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(DeleteMessageBatchResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<DeleteMessageBatchResultEntry.BuilderImpl> successful) {
            this.successful = DeleteMessageBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        public final Collection<BatchResultErrorEntry.Builder> getFailed() {
            return failed != null ? failed.stream().map(BatchResultErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public DeleteMessageBatchResponse build() {
            return new DeleteMessageBatchResponse(this);
        }
    }
}
