/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMessageRequest extends SQSRequest implements
        ToCopyableBuilder<DeleteMessageRequest.Builder, DeleteMessageRequest> {
    private final String queueUrl;

    private final String receiptHandle;

    private DeleteMessageRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.receiptHandle = builder.receiptHandle;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue from which messages are deleted.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue from which messages are deleted.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The receipt handle associated with the message to delete.
     * </p>
     * 
     * @return The receipt handle associated with the message to delete.
     */
    public String receiptHandle() {
        return receiptHandle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(receiptHandle());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageRequest)) {
            return false;
        }
        DeleteMessageRequest other = (DeleteMessageRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(receiptHandle(), other.receiptHandle());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteMessageRequest").add("QueueUrl", queueUrl()).add("ReceiptHandle", receiptHandle()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "ReceiptHandle":
            return Optional.of(clazz.cast(receiptHandle()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, DeleteMessageRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue from which messages are deleted.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue from which messages are deleted.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The receipt handle associated with the message to delete.
         * </p>
         * 
         * @param receiptHandle
         *        The receipt handle associated with the message to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private String receiptHandle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageRequest model) {
            queueUrl(model.queueUrl);
            receiptHandle(model.receiptHandle);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteMessageRequest build() {
            return new DeleteMessageRequest(this);
        }
    }
}
