/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of returned queue attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetQueueAttributesResponse extends SQSResponse implements
        ToCopyableBuilder<GetQueueAttributesResponse.Builder, GetQueueAttributesResponse> {
    private final Map<String, String> attributes;

    private GetQueueAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * A map of attributes to their respective values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attributes to their respective values.
     */
    public Map<QueueAttributeName, String> attributes() {
        return TypeConverter.convert(attributes, QueueAttributeName::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, QueueAttributeName.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * A map of attributes to their respective values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attributes to their respective values.
     */
    public Map<String, String> attributesStrings() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributesStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesResponse)) {
            return false;
        }
        GetQueueAttributesResponse other = (GetQueueAttributesResponse) obj;
        return Objects.equals(attributesStrings(), other.attributesStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("GetQueueAttributesResponse").add("Attributes", attributesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.of(clazz.cast(attributesStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, GetQueueAttributesResponse> {
        /**
         * <p>
         * A map of attributes to their respective values.
         * </p>
         * 
         * @param attributes
         *        A map of attributes to their respective values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesResponse model) {
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        @Override
        public GetQueueAttributesResponse build() {
            return new GetQueueAttributesResponse(this);
        }
    }
}
