/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetQueueUrlRequest extends SQSRequest implements ToCopyableBuilder<GetQueueUrlRequest.Builder, GetQueueUrlRequest> {
    private final String queueName;

    private final String queueOwnerAWSAccountId;

    private GetQueueUrlRequest(BuilderImpl builder) {
        super(builder);
        this.queueName = builder.queueName;
        this.queueOwnerAWSAccountId = builder.queueOwnerAWSAccountId;
    }

    /**
     * <p>
     * The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric characters,
     * hyphens (<code>-</code>), and underscores (<code>_</code>).
     * </p>
     * <p>
     * Queue names are case-sensitive.
     * </p>
     * 
     * @return The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric
     *         characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
     *         <p>
     *         Queue names are case-sensitive.
     */
    public String queueName() {
        return queueName;
    }

    /**
     * <p>
     * The AWS account ID of the account that created the queue.
     * </p>
     * 
     * @return The AWS account ID of the account that created the queue.
     */
    public String queueOwnerAWSAccountId() {
        return queueOwnerAWSAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode + Objects.hashCode(queueOwnerAWSAccountId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueUrlRequest)) {
            return false;
        }
        GetQueueUrlRequest other = (GetQueueUrlRequest) obj;
        return Objects.equals(queueName(), other.queueName())
                && Objects.equals(queueOwnerAWSAccountId(), other.queueOwnerAWSAccountId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetQueueUrlRequest").add("QueueName", queueName())
                .add("QueueOwnerAWSAccountId", queueOwnerAWSAccountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueName":
            return Optional.of(clazz.cast(queueName()));
        case "QueueOwnerAWSAccountId":
            return Optional.of(clazz.cast(queueOwnerAWSAccountId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, GetQueueUrlRequest> {
        /**
         * <p>
         * The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric
         * characters, hyphens (<code>-</code>), and underscores (<code>_</code>).
         * </p>
         * <p>
         * Queue names are case-sensitive.
         * </p>
         * 
         * @param queueName
         *        The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric
         *        characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
         *        <p>
         *        Queue names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The AWS account ID of the account that created the queue.
         * </p>
         * 
         * @param queueOwnerAWSAccountId
         *        The AWS account ID of the account that created the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueOwnerAWSAccountId(String queueOwnerAWSAccountId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueName;

        private String queueOwnerAWSAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueUrlRequest model) {
            queueName(model.queueName);
            queueOwnerAWSAccountId(model.queueOwnerAWSAccountId);
        }

        public final String getQueueName() {
            return queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final String getQueueOwnerAWSAccountId() {
            return queueOwnerAWSAccountId;
        }

        @Override
        public final Builder queueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.queueOwnerAWSAccountId = queueOwnerAWSAccountId;
            return this;
        }

        public final void setQueueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.queueOwnerAWSAccountId = queueOwnerAWSAccountId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetQueueUrlRequest build() {
            return new GetQueueUrlRequest(this);
        }
    }
}
