/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListQueueTagsResponse extends SQSResponse implements
        ToCopyableBuilder<ListQueueTagsResponse.Builder, ListQueueTagsResponse> {
    private final Map<String, String> tags;

    private ListQueueTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The list of all tags added to the specified queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of all tags added to the specified queue.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueTagsResponse)) {
            return false;
        }
        ListQueueTagsResponse other = (ListQueueTagsResponse) obj;
        return Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQueueTagsResponse").add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, ListQueueTagsResponse> {
        /**
         * <p>
         * The list of all tags added to the specified queue.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the specified queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private Map<String, String> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueTagsResponse model) {
            tags(model.tags);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public ListQueueTagsResponse build() {
            return new ListQueueTagsResponse(this);
        }
    }
}
