/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of received messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiveMessageResponse extends SQSResponse implements
        ToCopyableBuilder<ReceiveMessageResponse.Builder, ReceiveMessageResponse> {
    private final List<Message> messages;

    private ReceiveMessageResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
    }

    /**
     * <p>
     * A list of messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of messages.
     */
    public List<Message> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse other = (ReceiveMessageResponse) obj;
        return Objects.equals(messages(), other.messages());
    }

    @Override
    public String toString() {
        return ToString.builder("ReceiveMessageResponse").add("Messages", messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Messages":
            return Optional.of(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, ReceiveMessageResponse> {
        /**
         * <p>
         * A list of messages.
         * </p>
         * 
         * @param messages
         *        A list of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * A list of messages.
         * </p>
         * 
         * @param messages
         *        A list of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private List<Message> messages;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageResponse model) {
            messages(model.messages);
        }

        public final Collection<Message.Builder> getMessages() {
            return messages != null ? messages.stream().map(Message::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public ReceiveMessageResponse build() {
            return new ReceiveMessageResponse(this);
        }
    }
}
