/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>MD5OfMessageBody</code> and <code>MessageId</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SendMessageResponse extends SQSResponse implements
        ToCopyableBuilder<SendMessageResponse.Builder, SendMessageResponse> {
    private final String md5OfMessageBody;

    private final String md5OfMessageAttributes;

    private final String messageId;

    private final String sequenceNumber;

    private SendMessageResponse(BuilderImpl builder) {
        super(builder);
        this.md5OfMessageBody = builder.md5OfMessageBody;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.messageId = builder.messageId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon
     * SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
     *         Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
     *         digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public String md5OfMessageBody() {
        return md5OfMessageBody;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon
     * SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
     *         Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
     *         digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public String md5OfMessageAttributes() {
        return md5OfMessageAttributes;
    }

    /**
     * <p>
     * An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information, see <a
     * href
     * ="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
     * >Queue and Message Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     * </p>
     * 
     * @return An attribute containing the <code>MessageId</code> of the message sent to the queue. For more
     *         information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
     *         >Queue and Message Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     */
    public String messageId() {
        return messageId;
    }

    /**
     * <p>
     * This parameter applies only to FIFO (first-in-first-out) queues.
     * </p>
     * <p>
     * The large, non-consecutive number that Amazon SQS assigns to each message.
     * </p>
     * <p>
     * The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a
     * particular <code>MessageGroupId</code>.
     * </p>
     * 
     * @return This parameter applies only to FIFO (first-in-first-out) queues.</p>
     *         <p>
     *         The large, non-consecutive number that Amazon SQS assigns to each message.
     *         </p>
     *         <p>
     *         The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase
     *         for a particular <code>MessageGroupId</code>.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(md5OfMessageBody());
        hashCode = 31 * hashCode + Objects.hashCode(md5OfMessageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageResponse)) {
            return false;
        }
        SendMessageResponse other = (SendMessageResponse) obj;
        return Objects.equals(md5OfMessageBody(), other.md5OfMessageBody())
                && Objects.equals(md5OfMessageAttributes(), other.md5OfMessageAttributes())
                && Objects.equals(messageId(), other.messageId()) && Objects.equals(sequenceNumber(), other.sequenceNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("SendMessageResponse").add("MD5OfMessageBody", md5OfMessageBody())
                .add("MD5OfMessageAttributes", md5OfMessageAttributes()).add("MessageId", messageId())
                .add("SequenceNumber", sequenceNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MD5OfMessageBody":
            return Optional.of(clazz.cast(md5OfMessageBody()));
        case "MD5OfMessageAttributes":
            return Optional.of(clazz.cast(md5OfMessageAttributes()));
        case "MessageId":
            return Optional.of(clazz.cast(messageId()));
        case "SequenceNumber":
            return Optional.of(clazz.cast(sequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, SendMessageResponse> {
        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
         * Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.
         * For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageBody
         *        An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify
         *        that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the
         *        MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageBody(String md5OfMessageBody);

        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
         * Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.
         * For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageAttributes
         *        An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify
         *        that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the
         *        MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageAttributes(String md5OfMessageAttributes);

        /**
         * <p>
         * An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information,
         * see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
         * >Queue and Message Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * 
         * @param messageId
         *        An attribute containing the <code>MessageId</code> of the message sent to the queue. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html"
         *        >Queue and Message Identifiers</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * </p>
         * <p>
         * The large, non-consecutive number that Amazon SQS assigns to each message.
         * </p>
         * <p>
         * The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for
         * a particular <code>MessageGroupId</code>.
         * </p>
         * 
         * @param sequenceNumber
         *        This parameter applies only to FIFO (first-in-first-out) queues.</p>
         *        <p>
         *        The large, non-consecutive number that Amazon SQS assigns to each message.
         *        </p>
         *        <p>
         *        The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to
         *        increase for a particular <code>MessageGroupId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private String md5OfMessageBody;

        private String md5OfMessageAttributes;

        private String messageId;

        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageResponse model) {
            md5OfMessageBody(model.md5OfMessageBody);
            md5OfMessageAttributes(model.md5OfMessageAttributes);
            messageId(model.messageId);
            sequenceNumber(model.sequenceNumber);
        }

        public final String getMD5OfMessageBody() {
            return md5OfMessageBody;
        }

        @Override
        public final Builder md5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
            return this;
        }

        public final void setMD5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
        }

        public final String getMD5OfMessageAttributes() {
            return md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final void setMD5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public SendMessageResponse build() {
            return new SendMessageResponse(this);
        }
    }
}
