/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * SendMessageBatchRequestEntry StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendMessageBatchRequestEntryUnmarshaller implements
        Unmarshaller<SendMessageBatchRequestEntry, StaxUnmarshallerContext> {

    private static class MessageAttributesMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, MessageAttributeValue>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, MessageAttributeValue> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, MessageAttributeValue> entry = new MapEntry<String, MessageAttributeValue>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Value", targetDepth)) {
                        entry.setValue(MessageAttributeValueUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final MessageAttributesMapEntryUnmarshaller INSTANCE = new MessageAttributesMapEntryUnmarshaller();

        public static MessageAttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public SendMessageBatchRequestEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendMessageBatchRequestEntry.Builder sendMessageBatchRequestEntry = SendMessageBatchRequestEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.Map<String, MessageAttributeValue> messageAttributes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                sendMessageBatchRequestEntry.messageAttributes(messageAttributes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    sendMessageBatchRequestEntry.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MessageBody", targetDepth)) {
                    sendMessageBatchRequestEntry.messageBody(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DelaySeconds", targetDepth)) {
                    sendMessageBatchRequestEntry.delaySeconds(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MessageAttribute", targetDepth)) {
                    if (messageAttributes == null) {
                        messageAttributes = new java.util.HashMap<>();
                    }
                    Entry<String, MessageAttributeValue> entry = MessageAttributesMapEntryUnmarshaller.getInstance().unmarshall(
                            context);
                    // sendMessageBatchRequestEntry.addMessageAttributesEntry(entry.getKey(), entry.getValue());

                    messageAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }

                if (context.testExpression("MessageDeduplicationId", targetDepth)) {
                    sendMessageBatchRequestEntry.messageDeduplicationId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MessageGroupId", targetDepth)) {
                    sendMessageBatchRequestEntry.messageGroupId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    sendMessageBatchRequestEntry.messageAttributes(messageAttributes);
                    break;
                }
            }
        }
        return sendMessageBatchRequestEntry.build();
    }

    private static final SendMessageBatchRequestEntryUnmarshaller INSTANCE = new SendMessageBatchRequestEntryUnmarshaller();

    public static SendMessageBatchRequestEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
