/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * SendMessageBatchResultEntry StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendMessageBatchResultEntryUnmarshaller implements
        Unmarshaller<SendMessageBatchResultEntry, StaxUnmarshallerContext> {

    public SendMessageBatchResultEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendMessageBatchResultEntry.Builder sendMessageBatchResultEntry = SendMessageBatchResultEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    sendMessageBatchResultEntry.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MessageId", targetDepth)) {
                    sendMessageBatchResultEntry.messageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MD5OfMessageBody", targetDepth)) {
                    sendMessageBatchResultEntry.md5OfMessageBody(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MD5OfMessageAttributes", targetDepth)) {
                    sendMessageBatchResultEntry.md5OfMessageAttributes(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SequenceNumber", targetDepth)) {
                    sendMessageBatchResultEntry.sequenceNumber(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return sendMessageBatchResultEntry.build();
    }

    private static final SendMessageBatchResultEntryUnmarshaller INSTANCE = new SendMessageBatchResultEntryUnmarshaller();

    public static SendMessageBatchResultEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
