/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteQueueRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, DeleteQueueRequest> {
    private final String queueUrl;

    private DeleteQueueRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueueRequest)) {
            return false;
        }
        DeleteQueueRequest other = (DeleteQueueRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl());
    }

    public String toString() {
        return ToString.builder((String)"DeleteQueueRequest").add("QueueUrl", (Object)this.queueUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueueRequest model) {
            this.queueUrl(model.queueUrl);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteQueueRequest build() {
            return new DeleteQueueRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, DeleteQueueRequest> {
        public Builder queueUrl(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

