/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sqs.model.SQSResponse;
import software.amazon.awssdk.services.sqs.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListQueueTagsResponse
extends SQSResponse
implements ToCopyableBuilder<Builder, ListQueueTagsResponse> {
    private final Map<String, String> tags;

    private ListQueueTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueTagsResponse)) {
            return false;
        }
        ListQueueTagsResponse other = (ListQueueTagsResponse)((Object)obj);
        return Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ListQueueTagsResponse").add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSResponse.BuilderImpl
    implements Builder {
        private Map<String, String> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueTagsResponse model) {
            this.tags(model.tags);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public ListQueueTagsResponse build() {
            return new ListQueueTagsResponse(this);
        }
    }

    public static interface Builder
    extends SQSResponse.Builder,
    CopyableBuilder<Builder, ListQueueTagsResponse> {
        public Builder tags(Map<String, String> var1);
    }
}

