/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, SendMessageRequest> {
    private final String queueUrl;
    private final String messageBody;
    private final Integer delaySeconds;
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final String messageDeduplicationId;
    private final String messageGroupId;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.messageBody = builder.messageBody;
        this.delaySeconds = builder.delaySeconds;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String messageBody() {
        return this.messageBody;
    }

    public Integer delaySeconds() {
        return this.delaySeconds;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public String messageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public String messageGroupId() {
        return this.messageGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.delaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeduplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.messageBody(), other.messageBody()) && Objects.equals(this.delaySeconds(), other.delaySeconds()) && Objects.equals(this.messageAttributes(), other.messageAttributes()) && Objects.equals(this.messageDeduplicationId(), other.messageDeduplicationId()) && Objects.equals(this.messageGroupId(), other.messageGroupId());
    }

    public String toString() {
        return ToString.builder((String)"SendMessageRequest").add("QueueUrl", (Object)this.queueUrl()).add("MessageBody", (Object)this.messageBody()).add("DelaySeconds", (Object)this.delaySeconds()).add("MessageAttributes", this.messageAttributes()).add("MessageDeduplicationId", (Object)this.messageDeduplicationId()).add("MessageGroupId", (Object)this.messageGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "MessageBody": {
                return Optional.of(clazz.cast(this.messageBody()));
            }
            case "DelaySeconds": {
                return Optional.of(clazz.cast(this.delaySeconds()));
            }
            case "MessageAttributes": {
                return Optional.of(clazz.cast(this.messageAttributes()));
            }
            case "MessageDeduplicationId": {
                return Optional.of(clazz.cast(this.messageDeduplicationId()));
            }
            case "MessageGroupId": {
                return Optional.of(clazz.cast(this.messageGroupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private String messageBody;
        private Integer delaySeconds;
        private Map<String, MessageAttributeValue> messageAttributes;
        private String messageDeduplicationId;
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            this.queueUrl(model.queueUrl);
            this.messageBody(model.messageBody);
            this.delaySeconds(model.delaySeconds);
            this.messageAttributes(model.messageAttributes);
            this.messageDeduplicationId(model.messageDeduplicationId);
            this.messageGroupId(model.messageGroupId);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public final Integer getDelaySeconds() {
            return this.delaySeconds;
        }

        @Override
        public final Builder delaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        public final void setDelaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return this.messageAttributes != null ? CollectionUtils.mapValues(this.messageAttributes, MessageAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        public final String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        public final String getMessageGroupId() {
            return this.messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, SendMessageRequest> {
        public Builder queueUrl(String var1);

        public Builder messageBody(String var1);

        public Builder delaySeconds(Integer var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder messageDeduplicationId(String var1);

        public Builder messageGroupId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

