/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encloses a receipt handle and an identifier for it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMessageBatchRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteMessageBatchRequestEntry.Builder, DeleteMessageBatchRequestEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteMessageBatchRequestEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RECEIPT_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteMessageBatchRequestEntry::receiptHandle)).setter(setter(Builder::receiptHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptHandle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_FIELD, RECEIPT_HANDLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String receiptHandle;

    private DeleteMessageBatchRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.receiptHandle = builder.receiptHandle;
    }

    /**
     * <p>
     * An identifier for this particular receipt handle. This is used to communicate the result.
     * </p>
     * <note>
     * <p>
     * The <code>Id</code>s of a batch request need to be unique within a request
     * </p>
     * </note>
     * 
     * @return An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
     *         <p>
     *         The <code>Id</code>s of a batch request need to be unique within a request
     *         </p>
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A receipt handle.
     * </p>
     * 
     * @return A receipt handle.
     */
    public String receiptHandle() {
        return receiptHandle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(receiptHandle());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequestEntry)) {
            return false;
        }
        DeleteMessageBatchRequestEntry other = (DeleteMessageBatchRequestEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(receiptHandle(), other.receiptHandle());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteMessageBatchRequestEntry").add("Id", id()).add("ReceiptHandle", receiptHandle()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ReceiptHandle":
            return Optional.ofNullable(clazz.cast(receiptHandle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMessageBatchRequestEntry, T> g) {
        return obj -> g.apply((DeleteMessageBatchRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteMessageBatchRequestEntry> {
        /**
         * <p>
         * An identifier for this particular receipt handle. This is used to communicate the result.
         * </p>
         * <note>
         * <p>
         * The <code>Id</code>s of a batch request need to be unique within a request
         * </p>
         * </note>
         * 
         * @param id
         *        An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
         *        <p>
         *        The <code>Id</code>s of a batch request need to be unique within a request
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A receipt handle.
         * </p>
         * 
         * @param receiptHandle
         *        A receipt handle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String receiptHandle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchRequestEntry model) {
            id(model.id);
            receiptHandle(model.receiptHandle);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        @Override
        public DeleteMessageBatchRequestEntry build() {
            return new DeleteMessageBatchRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
