/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of your queues.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuesResponse extends SqsResponse implements
        ToCopyableBuilder<ListQueuesResponse.Builder, ListQueuesResponse> {
    private static final SdkField<List<String>> QUEUE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListQueuesResponse::queueUrls))
            .setter(setter(Builder::queueUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("QueueUrl")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("QueueUrl").build()).build()).isFlattened(true).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URLS_FIELD));

    private final List<String> queueUrls;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueUrls = builder.queueUrls;
    }

    /**
     * <p>
     * A list of queue URLs, up to 1,000 entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of queue URLs, up to 1,000 entries.
     */
    public List<String> queueUrls() {
        return queueUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse) obj;
        return Objects.equals(queueUrls(), other.queueUrls());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQueuesResponse").add("QueueUrls", queueUrls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrls":
            return Optional.ofNullable(clazz.cast(queueUrls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuesResponse> {
        /**
         * <p>
         * A list of queue URLs, up to 1,000 entries.
         * </p>
         * 
         * @param queueUrls
         *        A list of queue URLs, up to 1,000 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrls(Collection<String> queueUrls);

        /**
         * <p>
         * A list of queue URLs, up to 1,000 entries.
         * </p>
         * 
         * @param queueUrls
         *        A list of queue URLs, up to 1,000 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrls(String... queueUrls);
    }

    static final class BuilderImpl extends SqsResponse.BuilderImpl implements Builder {
        private List<String> queueUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            queueUrls(model.queueUrls);
        }

        public final Collection<String> getQueueUrls() {
            return queueUrls;
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String... queueUrls) {
            queueUrls(Arrays.asList(queueUrls));
            return this;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
