/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For each message in the batch, the response contains a <code> <a>SendMessageBatchResultEntry</a> </code> tag if the
 * message succeeds or a <code> <a>BatchResultErrorEntry</a> </code> tag if the message fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageBatchResponse extends SqsResponse implements
        ToCopyableBuilder<SendMessageBatchResponse.Builder, SendMessageBatchResponse> {
    private static final SdkField<List<SendMessageBatchResultEntry>> SUCCESSFUL_FIELD = SdkField
            .<List<SendMessageBatchResultEntry>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(SendMessageBatchResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendMessageBatchResultEntry")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SendMessageBatchResultEntry")
                            .memberFieldInfo(
                                    SdkField.<SendMessageBatchResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SendMessageBatchResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SendMessageBatchResultEntry").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<List<BatchResultErrorEntry>> FAILED_FIELD = SdkField
            .<List<BatchResultErrorEntry>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(SendMessageBatchResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchResultErrorEntry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BatchResultErrorEntry")
                            .memberFieldInfo(
                                    SdkField.<BatchResultErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchResultErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BatchResultErrorEntry").build()).build()).isFlattened(true)
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUCCESSFUL_FIELD, FAILED_FIELD));

    private final List<SendMessageBatchResultEntry> successful;

    private final List<BatchResultErrorEntry> failed;

    private SendMessageBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * Returns true if the Successful property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessful()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
     */
    public final List<SendMessageBatchResultEntry> successful() {
        return successful;
    }

    /**
     * Returns true if the Failed property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't be
     * enqueued.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailed()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that
     *         can't be enqueued.
     */
    public final List<BatchResultErrorEntry> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchResponse)) {
            return false;
        }
        SendMessageBatchResponse other = (SendMessageBatchResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageBatchResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Failed", hasFailed() ? failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageBatchResponse, T> g) {
        return obj -> g.apply((SendMessageBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageBatchResponse> {
        /**
         * <p>
         * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<SendMessageBatchResultEntry> successful);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(SendMessageBatchResultEntry... successful);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SendMessageBatchResultEntry>.Builder}
         * avoiding the need to create one manually via {@link List<SendMessageBatchResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SendMessageBatchResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #successful(List<SendMessageBatchResultEntry>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<SendMessageBatchResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<SendMessageBatchResultEntry>)
         */
        Builder successful(Consumer<SendMessageBatchResultEntry.Builder>... successful);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't
         * be enqueued.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that
         *        can't be enqueued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchResultErrorEntry> failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't
         * be enqueued.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that
         *        can't be enqueued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchResultErrorEntry... failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't
         * be enqueued.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchResultErrorEntry>.Builder} avoiding
         * the need to create one manually via {@link List<BatchResultErrorEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchResultErrorEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #failed(List<BatchResultErrorEntry>)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link List<BatchResultErrorEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(List<BatchResultErrorEntry>)
         */
        Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed);
    }

    static final class BuilderImpl extends SqsResponse.BuilderImpl implements Builder {
        private List<SendMessageBatchResultEntry> successful = DefaultSdkAutoConstructList.getInstance();

        private List<BatchResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchResponse model) {
            super(model);
            successful(model.successful);
            failed(model.failed);
        }

        public final Collection<SendMessageBatchResultEntry.Builder> getSuccessful() {
            if (successful instanceof SdkAutoConstructList) {
                return null;
            }
            return successful != null ? successful.stream().map(SendMessageBatchResultEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<SendMessageBatchResultEntry> successful) {
            this.successful = SendMessageBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(SendMessageBatchResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<SendMessageBatchResultEntry.Builder>... successful) {
            successful(Stream.of(successful).map(c -> SendMessageBatchResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<SendMessageBatchResultEntry.BuilderImpl> successful) {
            this.successful = SendMessageBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        public final Collection<BatchResultErrorEntry.Builder> getFailed() {
            if (failed instanceof SdkAutoConstructList) {
                return null;
            }
            return failed != null ? failed.stream().map(BatchResultErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchResultErrorEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public SendMessageBatchResponse build() {
            return new SendMessageBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
