/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encloses a <code>MessageId</code> for a successfully-enqueued message in a <code> <a>SendMessageBatch</a>.</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageBatchResultEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<SendMessageBatchResultEntry.Builder, SendMessageBatchResultEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SendMessageBatchResultEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(SendMessageBatchResultEntry::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> MD5_OF_MESSAGE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MD5OfMessageBody").getter(getter(SendMessageBatchResultEntry::md5OfMessageBody))
            .setter(setter(Builder::md5OfMessageBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageBody").build()).build();

    private static final SdkField<String> MD5_OF_MESSAGE_ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MD5OfMessageAttributes").getter(getter(SendMessageBatchResultEntry::md5OfMessageAttributes))
            .setter(setter(Builder::md5OfMessageAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageAttributes").build())
            .build();

    private static final SdkField<String> MD5_OF_MESSAGE_SYSTEM_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MD5OfMessageSystemAttributes")
            .getter(getter(SendMessageBatchResultEntry::md5OfMessageSystemAttributes))
            .setter(setter(Builder::md5OfMessageSystemAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageSystemAttributes")
                    .build()).build();

    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SequenceNumber").getter(getter(SendMessageBatchResultEntry::sequenceNumber))
            .setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MESSAGE_ID_FIELD,
            MD5_OF_MESSAGE_BODY_FIELD, MD5_OF_MESSAGE_ATTRIBUTES_FIELD, MD5_OF_MESSAGE_SYSTEM_ATTRIBUTES_FIELD,
            SEQUENCE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String messageId;

    private final String md5OfMessageBody;

    private final String md5OfMessageAttributes;

    private final String md5OfMessageSystemAttributes;

    private final String sequenceNumber;

    private SendMessageBatchResultEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.messageId = builder.messageId;
        this.md5OfMessageBody = builder.md5OfMessageBody;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.md5OfMessageSystemAttributes = builder.md5OfMessageSystemAttributes;
        this.sequenceNumber = builder.sequenceNumber;
    }

    /**
     * <p>
     * An identifier for the message in this batch.
     * </p>
     * 
     * @return An identifier for the message in this batch.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * An identifier for the message.
     * </p>
     * 
     * @return An identifier for the message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS
     * received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that
     *         Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
     *         digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public final String md5OfMessageBody() {
        return md5OfMessageBody;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon
     * SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
     *         Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
     *         digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public final String md5OfMessageAttributes() {
        return md5OfMessageAttributes;
    }

    /**
     * <p>
     * An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that
     * Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
     * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     * </p>
     * 
     * @return An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to
     *         verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating
     *         the MD5 digest. For information about MD5, see <a
     *         href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
     */
    public final String md5OfMessageSystemAttributes() {
        return md5OfMessageSystemAttributes;
    }

    /**
     * <p>
     * This parameter applies only to FIFO (first-in-first-out) queues.
     * </p>
     * <p>
     * The large, non-consecutive number that Amazon SQS assigns to each message.
     * </p>
     * <p>
     * The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to increase for a
     * particular <code>MessageGroupId</code>.
     * </p>
     * 
     * @return This parameter applies only to FIFO (first-in-first-out) queues.</p>
     *         <p>
     *         The large, non-consecutive number that Amazon SQS assigns to each message.
     *         </p>
     *         <p>
     *         The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to
     *         increase for a particular <code>MessageGroupId</code>.
     */
    public final String sequenceNumber() {
        return sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(md5OfMessageBody());
        hashCode = 31 * hashCode + Objects.hashCode(md5OfMessageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(md5OfMessageSystemAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchResultEntry)) {
            return false;
        }
        SendMessageBatchResultEntry other = (SendMessageBatchResultEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(md5OfMessageBody(), other.md5OfMessageBody())
                && Objects.equals(md5OfMessageAttributes(), other.md5OfMessageAttributes())
                && Objects.equals(md5OfMessageSystemAttributes(), other.md5OfMessageSystemAttributes())
                && Objects.equals(sequenceNumber(), other.sequenceNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageBatchResultEntry").add("Id", id()).add("MessageId", messageId())
                .add("MD5OfMessageBody", md5OfMessageBody()).add("MD5OfMessageAttributes", md5OfMessageAttributes())
                .add("MD5OfMessageSystemAttributes", md5OfMessageSystemAttributes()).add("SequenceNumber", sequenceNumber())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "MD5OfMessageBody":
            return Optional.ofNullable(clazz.cast(md5OfMessageBody()));
        case "MD5OfMessageAttributes":
            return Optional.ofNullable(clazz.cast(md5OfMessageAttributes()));
        case "MD5OfMessageSystemAttributes":
            return Optional.ofNullable(clazz.cast(md5OfMessageSystemAttributes()));
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageBatchResultEntry, T> g) {
        return obj -> g.apply((SendMessageBatchResultEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendMessageBatchResultEntry> {
        /**
         * <p>
         * An identifier for the message in this batch.
         * </p>
         * 
         * @param id
         *        An identifier for the message in this batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An identifier for the message.
         * </p>
         * 
         * @param messageId
         *        An identifier for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon
         * SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For
         * information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageBody
         *        An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that
         *        Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
         *        digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageBody(String md5OfMessageBody);

        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that
         * Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.
         * For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageAttributes
         *        An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify
         *        that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the
         *        MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageAttributes(String md5OfMessageAttributes);

        /**
         * <p>
         * An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify
         * that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5
         * digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * </p>
         * 
         * @param md5OfMessageSystemAttributes
         *        An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to
         *        verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before
         *        creating the MD5 digest. For information about MD5, see <a
         *        href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5OfMessageSystemAttributes(String md5OfMessageSystemAttributes);

        /**
         * <p>
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * </p>
         * <p>
         * The large, non-consecutive number that Amazon SQS assigns to each message.
         * </p>
         * <p>
         * The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to increase
         * for a particular <code>MessageGroupId</code>.
         * </p>
         * 
         * @param sequenceNumber
         *        This parameter applies only to FIFO (first-in-first-out) queues.</p>
         *        <p>
         *        The large, non-consecutive number that Amazon SQS assigns to each message.
         *        </p>
         *        <p>
         *        The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to
         *        increase for a particular <code>MessageGroupId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String messageId;

        private String md5OfMessageBody;

        private String md5OfMessageAttributes;

        private String md5OfMessageSystemAttributes;

        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchResultEntry model) {
            id(model.id);
            messageId(model.messageId);
            md5OfMessageBody(model.md5OfMessageBody);
            md5OfMessageAttributes(model.md5OfMessageAttributes);
            md5OfMessageSystemAttributes(model.md5OfMessageSystemAttributes);
            sequenceNumber(model.sequenceNumber);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getMd5OfMessageBody() {
            return md5OfMessageBody;
        }

        public final void setMd5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
        }

        @Override
        @Transient
        public final Builder md5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
            return this;
        }

        public final String getMd5OfMessageAttributes() {
            return md5OfMessageAttributes;
        }

        public final void setMd5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        @Override
        @Transient
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final String getMd5OfMessageSystemAttributes() {
            return md5OfMessageSystemAttributes;
        }

        public final void setMd5OfMessageSystemAttributes(String md5OfMessageSystemAttributes) {
            this.md5OfMessageSystemAttributes = md5OfMessageSystemAttributes;
        }

        @Override
        @Transient
        public final Builder md5OfMessageSystemAttributes(String md5OfMessageSystemAttributes) {
            this.md5OfMessageSystemAttributes = md5OfMessageSystemAttributes;
            return this;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        @Transient
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Override
        public SendMessageBatchResultEntry build() {
            return new SendMessageBatchResultEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
