/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum QueueAttributeName {
    ALL("All"),

    POLICY("Policy"),

    VISIBILITY_TIMEOUT("VisibilityTimeout"),

    MAXIMUM_MESSAGE_SIZE("MaximumMessageSize"),

    MESSAGE_RETENTION_PERIOD("MessageRetentionPeriod"),

    APPROXIMATE_NUMBER_OF_MESSAGES("ApproximateNumberOfMessages"),

    APPROXIMATE_NUMBER_OF_MESSAGES_NOT_VISIBLE("ApproximateNumberOfMessagesNotVisible"),

    CREATED_TIMESTAMP("CreatedTimestamp"),

    LAST_MODIFIED_TIMESTAMP("LastModifiedTimestamp"),

    QUEUE_ARN("QueueArn"),

    APPROXIMATE_NUMBER_OF_MESSAGES_DELAYED("ApproximateNumberOfMessagesDelayed"),

    DELAY_SECONDS("DelaySeconds"),

    RECEIVE_MESSAGE_WAIT_TIME_SECONDS("ReceiveMessageWaitTimeSeconds"),

    REDRIVE_POLICY("RedrivePolicy"),

    FIFO_QUEUE("FifoQueue"),

    CONTENT_BASED_DEDUPLICATION("ContentBasedDeduplication"),

    KMS_MASTER_KEY_ID("KmsMasterKeyId"),

    KMS_DATA_KEY_REUSE_PERIOD_SECONDS("KmsDataKeyReusePeriodSeconds"),

    DEDUPLICATION_SCOPE("DeduplicationScope"),

    FIFO_THROUGHPUT_LIMIT("FifoThroughputLimit"),

    REDRIVE_ALLOW_POLICY("RedriveAllowPolicy"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private QueueAttributeName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return QueueAttributeName corresponding to the value
     */
    public static QueueAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(QueueAttributeName.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link QueueAttributeName}s
     */
    public static Set<QueueAttributeName> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
