/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.DefaultSqsAsyncClient;
import software.amazon.awssdk.services.sqs.DefaultSqsBaseClientBuilder;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsServiceClientConfiguration;
import software.amazon.awssdk.services.sqs.endpoints.SqsEndpointProvider;
import software.amazon.awssdk.services.sqs.internal.MessageMD5ChecksumInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
final class DefaultSqsAsyncClientBuilder
extends DefaultSqsBaseClientBuilder<SqsAsyncClientBuilder, SqsAsyncClient>
implements SqsAsyncClientBuilder {
    DefaultSqsAsyncClientBuilder() {
    }

    @Override
    public DefaultSqsAsyncClientBuilder endpointProvider(SqsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SqsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        List interceptors = (List)clientConfiguration.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS);
        List<QueryParametersToBodyInterceptor> queryParamsToBodyInterceptor = Collections.singletonList(new QueryParametersToBodyInterceptor());
        ArrayList<MessageMD5ChecksumInterceptor> customizationInterceptors = new ArrayList<MessageMD5ChecksumInterceptor>();
        customizationInterceptors.add(new MessageMD5ChecksumInterceptor());
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, (List)interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, (List)interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
        DefaultSqsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SqsServiceClientConfiguration serviceClientConfiguration = SqsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSqsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

