/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueueUrlRequest extends SqsRequest implements
        ToCopyableBuilder<GetQueueUrlRequest.Builder, GetQueueUrlRequest> {
    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueName").getter(getter(GetQueueUrlRequest::queueName)).setter(setter(Builder::queueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()).build();

    private static final SdkField<String> QUEUE_OWNER_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueOwnerAWSAccountId").getter(getter(GetQueueUrlRequest::queueOwnerAWSAccountId))
            .setter(setter(Builder::queueOwnerAWSAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueOwnerAWSAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_NAME_FIELD,
            QUEUE_OWNER_AWS_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("QueueName", QUEUE_NAME_FIELD);
                    put("QueueOwnerAWSAccountId", QUEUE_OWNER_AWS_ACCOUNT_ID_FIELD);
                }
            });

    private final String queueName;

    private final String queueOwnerAWSAccountId;

    private GetQueueUrlRequest(BuilderImpl builder) {
        super(builder);
        this.queueName = builder.queueName;
        this.queueOwnerAWSAccountId = builder.queueOwnerAWSAccountId;
    }

    /**
     * <p>
     * The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric characters,
     * hyphens (<code>-</code>), and underscores (<code>_</code>).
     * </p>
     * <p>
     * Queue URLs and names are case-sensitive.
     * </p>
     * 
     * @return The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric
     *         characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
     *         <p>
     *         Queue URLs and names are case-sensitive.
     */
    public final String queueName() {
        return queueName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the account that created the queue.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the account that created the queue.
     */
    public final String queueOwnerAWSAccountId() {
        return queueOwnerAWSAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode + Objects.hashCode(queueOwnerAWSAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueUrlRequest)) {
            return false;
        }
        GetQueueUrlRequest other = (GetQueueUrlRequest) obj;
        return Objects.equals(queueName(), other.queueName())
                && Objects.equals(queueOwnerAWSAccountId(), other.queueOwnerAWSAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueueUrlRequest").add("QueueName", queueName())
                .add("QueueOwnerAWSAccountId", queueOwnerAWSAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueName":
            return Optional.ofNullable(clazz.cast(queueName()));
        case "QueueOwnerAWSAccountId":
            return Optional.ofNullable(clazz.cast(queueOwnerAWSAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueueUrlRequest, T> g) {
        return obj -> g.apply((GetQueueUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetQueueUrlRequest> {
        /**
         * <p>
         * The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric
         * characters, hyphens (<code>-</code>), and underscores (<code>_</code>).
         * </p>
         * <p>
         * Queue URLs and names are case-sensitive.
         * </p>
         * 
         * @param queueName
         *        The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric
         *        characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
         *        <p>
         *        Queue URLs and names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The Amazon Web Services account ID of the account that created the queue.
         * </p>
         * 
         * @param queueOwnerAWSAccountId
         *        The Amazon Web Services account ID of the account that created the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueOwnerAWSAccountId(String queueOwnerAWSAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String queueName;

        private String queueOwnerAWSAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueUrlRequest model) {
            super(model);
            queueName(model.queueName);
            queueOwnerAWSAccountId(model.queueOwnerAWSAccountId);
        }

        public final String getQueueName() {
            return queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final String getQueueOwnerAWSAccountId() {
            return queueOwnerAWSAccountId;
        }

        public final void setQueueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.queueOwnerAWSAccountId = queueOwnerAWSAccountId;
        }

        @Override
        public final Builder queueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.queueOwnerAWSAccountId = queueOwnerAWSAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQueueUrlRequest build() {
            return new GetQueueUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
