/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of received messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceiveMessageResponse extends SqsResponse implements
        ToCopyableBuilder<ReceiveMessageResponse.Builder, ReceiveMessageResponse> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("Messages")
            .getter(getter(ReceiveMessageResponse::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Messages", MESSAGES_FIELD);
                }
            });

    private final List<Message> messages;

    private ReceiveMessageResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return A list of messages.
     */
    public final List<Message> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse other = (ReceiveMessageResponse) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReceiveMessageResponse").add("Messages", hasMessages() ? messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReceiveMessageResponse, T> g) {
        return obj -> g.apply((ReceiveMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ReceiveMessageResponse> {
        /**
         * <p>
         * A list of messages.
         * </p>
         * 
         * @param messages
         *        A list of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * A list of messages.
         * </p>
         * 
         * @param messages
         *        A list of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * A list of messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sqs.model.Message.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sqs.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sqs.model.Message.Builder#build()} is called immediately and its
         * result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sqs.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);
    }

    static final class BuilderImpl extends SqsResponse.BuilderImpl implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageResponse model) {
            super(model);
            messages(model.messages);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessageListCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReceiveMessageResponse build() {
            return new ReceiveMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
