/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageBatchRequest extends SqsRequest implements
        ToCopyableBuilder<SendMessageBatchRequest.Builder, SendMessageBatchRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueUrl").getter(getter(SendMessageBatchRequest::queueUrl)).setter(setter(Builder::queueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()).build();

    private static final SdkField<List<SendMessageBatchRequestEntry>> ENTRIES_FIELD = SdkField
            .<List<SendMessageBatchRequestEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(SendMessageBatchRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SendMessageBatchRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SendMessageBatchRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(QUEUE_URL_FIELD, ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("QueueUrl", QUEUE_URL_FIELD);
                    put("Entries", ENTRIES_FIELD);
                }
            });

    private final String queueUrl;

    private final List<SendMessageBatchRequestEntry> entries;

    private SendMessageBatchRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue to which batched messages are sent.
     * </p>
     * <p>
     * Queue URLs and names are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue to which batched messages are sent.</p>
     *         <p>
     *         Queue URLs and names are case-sensitive.
     */
    public final String queueUrl() {
        return queueUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
     */
    public final List<SendMessageBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequest)) {
            return false;
        }
        SendMessageBatchRequest other = (SendMessageBatchRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && hasEntries() == other.hasEntries()
                && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageBatchRequest").add("QueueUrl", queueUrl())
                .add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.ofNullable(clazz.cast(queueUrl()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageBatchRequest, T> g) {
        return obj -> g.apply((SendMessageBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageBatchRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue to which batched messages are sent.
         * </p>
         * <p>
         * Queue URLs and names are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue to which batched messages are sent.</p>
         *        <p>
         *        Queue URLs and names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * </p>
         * 
         * @param entries
         *        A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<SendMessageBatchRequestEntry> entries);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * </p>
         * 
         * @param entries
         *        A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(SendMessageBatchRequestEntry... entries);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<SendMessageBatchRequestEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<SendMessageBatchRequestEntry>)
         */
        Builder entries(Consumer<SendMessageBatchRequestEntry.Builder>... entries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private List<SendMessageBatchRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            entries(model.entries);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final List<SendMessageBatchRequestEntry.Builder> getEntries() {
            List<SendMessageBatchRequestEntry.Builder> result = SendMessageBatchRequestEntryListCopier
                    .copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<SendMessageBatchRequestEntry.BuilderImpl> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<SendMessageBatchRequestEntry> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(SendMessageBatchRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<SendMessageBatchRequestEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> SendMessageBatchRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageBatchRequest build() {
            return new SendMessageBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
