/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gives a detailed description of the result of an action on each entry in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchResultErrorEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchResultErrorEntry.Builder, BatchResultErrorEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(BatchResultErrorEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Boolean> SENDER_FAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SenderFault").getter(getter(BatchResultErrorEntry::senderFault)).setter(setter(Builder::senderFault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderFault").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(BatchResultErrorEntry::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchResultErrorEntry::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SENDER_FAULT_FIELD,
            CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("SenderFault", SENDER_FAULT_FIELD);
                    put("Code", CODE_FIELD);
                    put("Message", MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Boolean senderFault;

    private final String code;

    private final String message;

    private BatchResultErrorEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.senderFault = builder.senderFault;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The <code>Id</code> of an entry in a batch request.
     * </p>
     * 
     * @return The <code>Id</code> of an entry in a batch request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the error happened due to the caller of the batch API action.
     * </p>
     * 
     * @return Specifies whether the error happened due to the caller of the batch API action.
     */
    public final Boolean senderFault() {
        return senderFault;
    }

    /**
     * <p>
     * An error code representing why the action failed on this entry.
     * </p>
     * 
     * @return An error code representing why the action failed on this entry.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * A message explaining why the action failed on this entry.
     * </p>
     * 
     * @return A message explaining why the action failed on this entry.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(senderFault());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchResultErrorEntry)) {
            return false;
        }
        BatchResultErrorEntry other = (BatchResultErrorEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(senderFault(), other.senderFault())
                && Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchResultErrorEntry").add("Id", id()).add("SenderFault", senderFault()).add("Code", code())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "SenderFault":
            return Optional.ofNullable(clazz.cast(senderFault()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchResultErrorEntry, T> g) {
        return obj -> g.apply((BatchResultErrorEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchResultErrorEntry> {
        /**
         * <p>
         * The <code>Id</code> of an entry in a batch request.
         * </p>
         * 
         * @param id
         *        The <code>Id</code> of an entry in a batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the error happened due to the caller of the batch API action.
         * </p>
         * 
         * @param senderFault
         *        Specifies whether the error happened due to the caller of the batch API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderFault(Boolean senderFault);

        /**
         * <p>
         * An error code representing why the action failed on this entry.
         * </p>
         * 
         * @param code
         *        An error code representing why the action failed on this entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A message explaining why the action failed on this entry.
         * </p>
         * 
         * @param message
         *        A message explaining why the action failed on this entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Boolean senderFault;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchResultErrorEntry model) {
            id(model.id);
            senderFault(model.senderFault);
            code(model.code);
            message(model.message);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getSenderFault() {
            return senderFault;
        }

        public final void setSenderFault(Boolean senderFault) {
            this.senderFault = senderFault;
        }

        @Override
        public final Builder senderFault(Boolean senderFault) {
            this.senderFault = senderFault;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchResultErrorEntry build() {
            return new BatchResultErrorEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
