/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuesRequest extends SqsRequest implements
        ToCopyableBuilder<ListQueuesRequest.Builder, ListQueuesRequest> {
    private static final SdkField<String> QUEUE_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListQueuesRequest::queueNamePrefix)).setter(setter(Builder::queueNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueNamePrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_NAME_PREFIX_FIELD));

    private final String queueNamePrefix;

    private ListQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.queueNamePrefix = builder.queueNamePrefix;
    }

    /**
     * <p>
     * A string to use for filtering the list results. Only those queues whose name begins with the specified string are
     * returned.
     * </p>
     * <p>
     * Queue URLs and names are case-sensitive.
     * </p>
     * 
     * @return A string to use for filtering the list results. Only those queues whose name begins with the specified
     *         string are returned.</p>
     *         <p>
     *         Queue URLs and names are case-sensitive.
     */
    public String queueNamePrefix() {
        return queueNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueNamePrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest) obj;
        return Objects.equals(queueNamePrefix(), other.queueNamePrefix());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQueuesRequest").add("QueueNamePrefix", queueNamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueNamePrefix":
            return Optional.ofNullable(clazz.cast(queueNamePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesRequest, T> g) {
        return obj -> g.apply((ListQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuesRequest> {
        /**
         * <p>
         * A string to use for filtering the list results. Only those queues whose name begins with the specified string
         * are returned.
         * </p>
         * <p>
         * Queue URLs and names are case-sensitive.
         * </p>
         * 
         * @param queueNamePrefix
         *        A string to use for filtering the list results. Only those queues whose name begins with the specified
         *        string are returned.</p>
         *        <p>
         *        Queue URLs and names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueNamePrefix(String queueNamePrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String queueNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            super(model);
            queueNamePrefix(model.queueNamePrefix);
        }

        public final String getQueueNamePrefix() {
            return queueNamePrefix;
        }

        @Override
        public final Builder queueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
            return this;
        }

        public final void setQueueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
