/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.batchmanager;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.batchmanager.BatchOverrideConfiguration;
import software.amazon.awssdk.services.sqs.internal.batchmanager.DefaultSqsAsyncBatchManager;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
public interface SqsAsyncBatchManager
extends SdkAutoCloseable {
    public static Builder builder() {
        return DefaultSqsAsyncBatchManager.builder();
    }

    default public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest request) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SendMessageResponse> sendMessage(Consumer<SendMessageRequest.Builder> sendMessageRequest) {
        return this.sendMessage((SendMessageRequest)((Object)((SendMessageRequest.Builder)SendMessageRequest.builder().applyMutation(sendMessageRequest)).build()));
    }

    default public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest request) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteMessageResponse> deleteMessage(Consumer<DeleteMessageRequest.Builder> request) {
        return this.deleteMessage((DeleteMessageRequest)((Object)((DeleteMessageRequest.Builder)DeleteMessageRequest.builder().applyMutation(request)).build()));
    }

    default public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest request) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(Consumer<ChangeMessageVisibilityRequest.Builder> request) {
        return this.changeMessageVisibility((ChangeMessageVisibilityRequest)((Object)((ChangeMessageVisibilityRequest.Builder)ChangeMessageVisibilityRequest.builder().applyMutation(request)).build()));
    }

    default public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest request) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ReceiveMessageResponse> receiveMessage(Consumer<ReceiveMessageRequest.Builder> request) {
        return this.receiveMessage((ReceiveMessageRequest)((Object)((ReceiveMessageRequest.Builder)ReceiveMessageRequest.builder().applyMutation(request)).build()));
    }

    public static interface Builder {
        public Builder overrideConfiguration(BatchOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<BatchOverrideConfiguration.Builder> overrideConfiguration) {
            return this.overrideConfiguration(((BatchOverrideConfiguration.Builder)BatchOverrideConfiguration.builder().applyMutation(overrideConfiguration)).build());
        }

        public Builder client(SqsAsyncClient var1);

        public Builder scheduledExecutor(ScheduledExecutorService var1);

        public SqsAsyncBatchManager build();
    }
}

