/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.UserAgentUtils;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;

public class ListQueuesPublisher
implements SdkPublisher<ListQueuesResponse> {
    private final SqsAsyncClient client;
    private final ListQueuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueuesPublisher(SqsAsyncClient client, ListQueuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueuesPublisher(SqsAsyncClient client, ListQueuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> queueUrls() {
        Function<ListQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueUrls() != null) {
                return response.queueUrls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueuesResponseFetcher
    implements AsyncPageFetcher<ListQueuesResponse> {
        private ListQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueuesResponse> nextPage(ListQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListQueuesPublisher.this.client.listQueues(ListQueuesPublisher.this.firstRequest);
            }
            return ListQueuesPublisher.this.client.listQueues((ListQueuesRequest)((Object)ListQueuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

