/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.QueueAttributesManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ReceiveQueueBuffer;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ResponseBatchConfiguration;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
public class ReceiveBatchManager
implements SdkAutoCloseable {
    private final SqsAsyncClient sqsClient;
    private final ScheduledExecutorService executor;
    private final ResponseBatchConfiguration config;
    private final String queueUrl;
    private final ReceiveQueueBuffer receiveQueueBuffer;
    private final QueueAttributesManager queueAttributesManager;

    public ReceiveBatchManager(SqsAsyncClient sqsClient, ScheduledExecutorService executor, ResponseBatchConfiguration config, String queueUrl) {
        this.sqsClient = sqsClient;
        this.executor = executor;
        this.config = config;
        this.queueUrl = queueUrl;
        this.queueAttributesManager = new QueueAttributesManager(sqsClient, queueUrl);
        this.receiveQueueBuffer = ReceiveQueueBuffer.builder().executor(executor).sqsClient(sqsClient).config(config).queueUrl(queueUrl).queueAttributesManager(this.queueAttributesManager).build();
    }

    public CompletableFuture<ReceiveMessageResponse> processRequest(ReceiveMessageRequest rq) {
        if (this.receiveQueueBuffer.isShutDown()) {
            throw new IllegalStateException("The client has been shut down.");
        }
        int numMessages = rq.maxNumberOfMessages() != null ? rq.maxNumberOfMessages() : 10;
        return this.queueAttributesManager.getReceiveMessageTimeout(rq, this.config.messageMinWaitDuration()).thenCompose(waitTimeMs -> {
            CompletableFuture<ReceiveMessageResponse> receiveMessageFuture = new CompletableFuture<ReceiveMessageResponse>();
            this.receiveQueueBuffer.receiveMessage(receiveMessageFuture, numMessages);
            this.executor.schedule(() -> receiveMessageFuture.complete((ReceiveMessageResponse)((Object)((Object)((Object)ReceiveMessageResponse.builder().build())))), waitTimeMs.toMillis(), TimeUnit.MILLISECONDS);
            return receiveMessageFuture;
        });
    }

    public void close() {
        this.receiveQueueBuffer.close();
    }
}

